/*
 * Decompiled with CFR 0.152.
 */
package com.ghasto.logistical_improvements.mixin;

import com.ghasto.logistical_improvements.BatchSizeAccessor;
import com.ghasto.logistical_improvements.ConfigureBatchSize;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelScreen;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FactoryPanelScreen.class}, remap=false)
public abstract class FactoryPanelScreenMixin
extends AbstractSimiScreen {
    @Shadow
    private FactoryPanelBehaviour behaviour;
    @Shadow
    private boolean restocker;
    @Shadow
    private boolean sendReset;
    @Unique
    private ScrollInput minimumBatchSize;

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (!this.restocker) {
            return;
        }
        this.minimumBatchSize = new ScrollInput(this.guiLeft + 8, this.guiTop + this.windowHeight - 24, 31, 16).withRange(1, 577).withStepFunction(c -> c.currentValue < 64 && c.forward ? (c.shift ? 4 : 1) : 64).titled(Component.translatable((String)"tooltip.vanilla_logistics.minimum_batch_size"));
        this.minimumBatchSize.setState(((BatchSizeAccessor)this.behaviour).getMinimumBatchSize());
        this.addRenderableWidget((GuiEventListener)this.minimumBatchSize);
    }

    @Inject(method={"renderWindow"}, at={@At(value="TAIL")})
    private void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        if (this.minimumBatchSize == null) {
            return;
        }
        if (!this.restocker) {
            return;
        }
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"vanilla_logistics", (String)"textures/gui/batch_size_prompt.png"), this.minimumBatchSize.getX() - 1, this.minimumBatchSize.getY() - 1, 0.0f, 0.0f, 42, 18, 64, 64);
        graphics.blit(ResourceLocation.fromNamespaceAndPath((String)"vanilla_logistics", (String)"textures/gui/bar.png"), this.guiLeft + 51, this.guiTop + this.windowHeight - 32, 0.0f, 0.0f, 2, 32, 32, 32);
        int state = this.minimumBatchSize.getState();
        graphics.drawCenteredString(this.font, (Component)Component.literal((String)(state == 1 ? "/" : "" + state)), this.minimumBatchSize.getX() + 15, this.minimumBatchSize.getY() + 4, -1118482);
    }

    @Inject(method={"sendIt"}, at={@At(value="INVOKE", target="Lnet/createmod/catnip/platform/services/NetworkHelper;sendToServer(Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;)V", shift=At.Shift.AFTER)})
    private void sendIt(FactoryPanelPosition toRemove, boolean clearPromises, CallbackInfo ci) {
        if (!this.restocker) {
            return;
        }
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new ConfigureBatchSize(this.behaviour.getPanelPosition(), this.sendReset ? 1 : this.minimumBatchSize.getState()));
    }
}

