/*
 * Decompiled with CFR 0.152.
 */
package com.ghasto.logistical_improvements.cog_material;

import com.ghasto.logistical_improvements.VanillaLogisticsClient;
import com.ghasto.logistical_improvements.cog_material.CogMaterialAccessor;
import com.ghasto.logistical_improvements.mixin.cog_material.WaterWheelRendererAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.model.BakedModelHelper;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBuilder;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.StitchedSprite;
import net.createmod.catnip.render.SuperBufferFactory;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CogMaterial {
    public static final SuperByteBufferCache.Compartment<ModelKey> COMPARTMENT = new SuperByteBufferCache.Compartment();
    public static final RendererReloadCache<ModelKey, Model> MODEL_CACHE = new RendererReloadCache(CogMaterial::createModel);
    private static final StitchedSprite SPRUCE_PLANKS = new StitchedSprite(ResourceLocation.withDefaultNamespace((String)"block/spruce_planks"));
    private static final StitchedSprite STRIPPED_SPRUCE_LOG = new StitchedSprite(ResourceLocation.withDefaultNamespace((String)"block/stripped_spruce_log_top"));

    public static SuperByteBuffer createBuffer(boolean large, boolean shaft, KineticBlockEntity blockEntity) {
        ModelKey key = new ModelKey(large, shaft, blockEntity.getBlockState(), ((CogMaterialAccessor)blockEntity).getMaterial());
        return SuperByteBufferCache.getInstance().get(COMPARTMENT, (Object)key, () -> {
            BakedModel model = CogMaterial.generateModel(key.getModel().get(), key.material());
            BlockState blockState = key.state();
            boolean hasDirection = blockState.hasProperty((Property)BlockStateProperties.AXIS);
            Direction dir = Direction.fromAxisAndDirection((Direction.Axis)(hasDirection ? (Direction.Axis)blockState.getValue((Property)BlockStateProperties.AXIS) : Direction.Axis.Y), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            PoseStack transform = (PoseStack)CachedBuffers.rotateToFaceVertical((Direction)dir).get();
            return SuperBufferFactory.getInstance().createForBlock(model, Blocks.AIR.defaultBlockState(), transform);
        });
    }

    public static BakedModel generateModel(BakedModel template, BlockState planks) {
        Block planksBlock = planks.getBlock();
        ResourceLocation id = RegisteredObjectsHelper.getKeyOrThrow((Block)planksBlock);
        String wood = WaterWheelRendererAccessor.invokePlankStateToWoodName(planks);
        BlockState strippedLog = WaterWheelRendererAccessor.invokeGetLogBlockstate(id.getNamespace(), "stripped_" + wood);
        TextureAtlasSprite planksTexture = WaterWheelRendererAccessor.invokeGetSpriteOnSide(planks, Direction.SOUTH);
        TextureAtlasSprite logTexture = WaterWheelRendererAccessor.invokeGetSpriteOnSide(strippedLog, Direction.UP);
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        map.put(SPRUCE_PLANKS.get(), planksTexture);
        map.put(STRIPPED_SPRUCE_LOG.get(), logTexture);
        return BakedModelHelper.generateModel((BakedModel)template, ((Map)map)::get);
    }

    public static Model createModel(ModelKey key) {
        BakedModel model = CogMaterial.generateModel(key.getModel().get(), key.material());
        return new BakedModelBuilder(model).build();
    }

    public record ModelKey(boolean large, boolean shaft, BlockState state, BlockState material) {
        public PartialModel getModel() {
            if (this.material == Blocks.SPRUCE_PLANKS.defaultBlockState()) {
                return this.large ? AllPartialModels.SHAFTLESS_LARGE_COGWHEEL : (this.shaft ? AllPartialModels.COGWHEEL : AllPartialModels.SHAFTLESS_COGWHEEL);
            }
            return this.large ? VanillaLogisticsClient.LARGE_COGWHEEL_SHAFTLESS : (this.shaft ? VanillaLogisticsClient.COGWHEEL : VanillaLogisticsClient.COGWHEEL_SHAFTLESS);
        }
    }
}

