/*
 * Decompiled with CFR 0.152.
 */
package com.ghasto.logistical_improvements.mixin.cog_material;

import com.ghasto.logistical_improvements.cog_material.CogMaterialAccessor;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KineticBlockEntity.class})
public abstract class KineticBlockEntityMixin
extends SmartBlockEntity
implements CogMaterialAccessor {
    @Unique
    private BlockState material = Blocks.SPRUCE_PLANKS.defaultBlockState();

    public KineticBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    public BlockState getMaterial() {
        return this.material;
    }

    @Override
    public void setMaterial(BlockState material) {
        this.material = material;
        this.notifyUpdate();
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    private void injectWrite(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        tag.put("cog_material", (Tag)NbtUtils.writeBlockState((BlockState)this.material));
    }

    @Inject(method={"read"}, at={@At(value="TAIL")})
    private void injectRead(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        this.material = NbtUtils.readBlockState((HolderGetter)registries.lookupOrThrow(Registries.BLOCK), (CompoundTag)compound.getCompound("cog_material"));
    }

    @Inject(method={"switchToBlockState"}, at={@At(value="TAIL")})
    private static void keepMaterial(Level world, BlockPos pos, BlockState state, CallbackInfo ci, @Local BlockEntity blockEntity) {
        BlockEntity newBlockEntity = world.getBlockEntity(pos);
        if (newBlockEntity instanceof CogMaterialAccessor) {
            CogMaterialAccessor accessor = (CogMaterialAccessor)newBlockEntity;
            if (blockEntity instanceof CogMaterialAccessor) {
                CogMaterialAccessor oldAccessor = (CogMaterialAccessor)blockEntity;
                accessor.setMaterial(oldAccessor.getMaterial());
            }
        }
    }
}

