/*
 * Decompiled with CFR 0.152.
 */
package fuzs.portablehole;

import fuzs.portablehole.config.ClientConfig;
import fuzs.portablehole.config.ServerConfig;
import fuzs.portablehole.init.ModRegistry;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.event.v1.BuildCreativeModeTabContentsCallback;
import fuzs.puzzleslib.api.event.v1.server.LootTableLoadCallback;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PortableHole
implements ModConstructor {
    public static final String MOD_ID = "portablehole";
    public static final String MOD_NAME = "Portable Hole";
    public static final Logger LOGGER = LogManager.getLogger((String)"Portable Hole");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"portablehole").client(ClientConfig.class).server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.bootstrap();
        PortableHole.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        LootTableLoadCallback.EVENT.register((resourceLocation, builder, provider) -> {
            if (BuiltInLootTables.STRONGHOLD_CORRIDOR.location().equals((Object)resourceLocation)) {
                builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(ModRegistry.STRONGHOLD_CORRIDOR_INJECT_LOOT_TABLE)));
            }
        });
        BuildCreativeModeTabContentsCallback.buildCreativeModeTabContents((ResourceKey)CreativeModeTabs.TOOLS_AND_UTILITIES).register((creativeModeTab, itemDisplayParameters, output) -> output.accept((ItemLike)ModRegistry.PORTABLE_HOLE_ITEM.value()));
    }

    public static ResourceLocation id(String path) {
        return ResourceLocationHelper.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

