/*
 * Decompiled with CFR 0.152.
 */
package fuzs.portablehole.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.portablehole.PortableHole;
import fuzs.portablehole.config.ServerConfig;
import fuzs.portablehole.world.level.block.entity.TemporaryHoleBlockEntity;
import java.util.EnumSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.blockentity.state.EndPortalRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class TemporaryHoleRenderer
implements BlockEntityRenderer<TemporaryHoleBlockEntity, EndPortalRenderState> {
    public TemporaryHoleRenderer(BlockEntityRendererProvider.Context context) {
    }

    public EndPortalRenderState createRenderState() {
        return new EndPortalRenderState();
    }

    public void extractRenderState(TemporaryHoleBlockEntity blockEntity, EndPortalRenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, crumblingOverlay);
        renderState.facesToShow.clear();
        for (Direction direction : Direction.values()) {
            if (!blockEntity.shouldRenderFace(direction)) continue;
            renderState.facesToShow.add(direction);
        }
    }

    public void submit(EndPortalRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (!((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).visuals.portalOverlay) {
            return;
        }
        submitNodeCollector.submitCustomGeometry(poseStack, RenderType.endGateway(), (pose, vertexConsumer) -> this.renderCube(renderState.facesToShow, pose.pose(), vertexConsumer));
    }

    private void renderCube(EnumSet<Direction> facesToShow, Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        this.renderFace(facesToShow, matrix4f, vertexConsumer, 0.0f, 1.0f, 0.0f, 1.0f, 0.9995f, 0.9995f, 0.9995f, 0.9995f, Direction.SOUTH);
        this.renderFace(facesToShow, matrix4f, vertexConsumer, 0.0f, 1.0f, 1.0f, 0.0f, 5.0E-4f, 5.0E-4f, 5.0E-4f, 5.0E-4f, Direction.NORTH);
        this.renderFace(facesToShow, matrix4f, vertexConsumer, 0.9995f, 0.9995f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.EAST);
        this.renderFace(facesToShow, matrix4f, vertexConsumer, 5.0E-4f, 5.0E-4f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.WEST);
        this.renderFace(facesToShow, matrix4f, vertexConsumer, 0.0f, 1.0f, 5.0E-4f, 5.0E-4f, 0.0f, 0.0f, 1.0f, 1.0f, Direction.DOWN);
        this.renderFace(facesToShow, matrix4f, vertexConsumer, 0.0f, 1.0f, 0.9995f, 0.9995f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP);
    }

    private void renderFace(EnumSet<Direction> facesToShow, Matrix4f matrix4f, VertexConsumer vertexConsumer, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3, Direction direction) {
        if (facesToShow.contains(direction)) {
            vertexConsumer.addVertex(matrix4f, x0, y1, z3);
            vertexConsumer.addVertex(matrix4f, x1, y1, z2);
            vertexConsumer.addVertex(matrix4f, x1, y0, z1);
            vertexConsumer.addVertex(matrix4f, x0, y0, z0);
        }
    }
}

