/*
 * Decompiled with CFR 0.152.
 */
package fuzs.portablehole.world.item;

import fuzs.portablehole.PortableHole;
import fuzs.portablehole.config.ServerConfig;
import fuzs.portablehole.world.level.block.entity.TemporaryHoleBlockEntity;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class PortableHoleItem
extends Item {
    public PortableHoleItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        Player player = context.getPlayer();
        Direction clickedFace = context.getClickedFace();
        if (TemporaryHoleBlockEntity.isValidHolePosition(level, clickedPos)) {
            if (!level.isClientSide()) {
                List<BlockPos> positionsInPlane = BlockPos.betweenClosedStream((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1).filter(pos -> clickedFace.getAxis().choose(pos.getX(), pos.getY(), pos.getZ()) == 0).map(BlockPos::immutable).toList();
                for (BlockPos pos2 : positionsInPlane) {
                    TemporaryHoleBlockEntity.setTemporaryHoleBlock(level, pos2.offset((Vec3i)clickedPos), clickedFace.getOpposite(), ((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).temporaryHoleDepth);
                }
                level.playSound(null, (double)clickedPos.getX(), (double)clickedPos.getY(), (double)clickedPos.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
                ItemStack itemInHand = player.getItemInHand(context.getHand());
                player.getCooldowns().addCooldown(itemInHand, ((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).portableHoleCooldown);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            return InteractionResultHelper.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public Component getDescriptionComponent() {
        return Component.translatable((String)(this.getDescriptionId() + ".description")).withStyle(ChatFormatting.GOLD);
    }
}

