/*
 * Decompiled with CFR 0.152.
 */
package fuzs.portablehole.world.level.block.entity;

import com.mojang.serialization.Codec;
import fuzs.portablehole.PortableHole;
import fuzs.portablehole.config.ServerConfig;
import fuzs.portablehole.init.ModRegistry;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.puzzleslib.api.util.v1.ValueSerializationHelper;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class TemporaryHoleBlockEntity
extends BlockEntity
implements TickingBlockEntity {
    public static final String TAG_BLOCK_STATE_SOURCE = PortableHole.id("source_state").toString();
    public static final String TAG_BLOCK_ENTITY_SOURCE_TAG = PortableHole.id("source_block_entity_tag").toString();
    public static final String TAG_LIFETIME_TICKS = PortableHole.id("lifetime_ticks").toString();
    public static final String TAG_GROWTH_DIRECTION = PortableHole.id("growth_direction").toString();
    public static final String TAG_GROWTH_DISTANCE = PortableHole.id("growth_distance").toString();
    private BlockState sourceState;
    @Nullable
    private CompoundTag blockEntityTag;
    private int lifetimeTicks;
    @Nullable
    private Direction growthDirection;
    private int growthDistance;

    public TemporaryHoleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.TEMPORARY_HOLE_BLOCK_ENTITY_TYPE.value(), pos, state);
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.sourceState = valueInput.read(TAG_BLOCK_STATE_SOURCE, BlockState.CODEC).filter(Predicate.not(BlockBehaviour.BlockStateBase::isAir)).orElse(null);
        this.blockEntityTag = valueInput.read(TAG_BLOCK_ENTITY_SOURCE_TAG, CompoundTag.CODEC).orElse(null);
        this.lifetimeTicks = valueInput.getIntOr(TAG_LIFETIME_TICKS, 0);
        this.growthDirection = valueInput.read(TAG_GROWTH_DIRECTION, (Codec)Direction.CODEC).orElse(null);
        this.growthDistance = valueInput.getIntOr(TAG_GROWTH_DISTANCE, 0);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.storeNullable(TAG_BLOCK_STATE_SOURCE, BlockState.CODEC, (Object)this.sourceState);
        valueOutput.storeNullable(TAG_BLOCK_ENTITY_SOURCE_TAG, CompoundTag.CODEC, (Object)this.blockEntityTag);
        valueOutput.putInt(TAG_LIFETIME_TICKS, this.lifetimeTicks);
        valueOutput.storeNullable(TAG_GROWTH_DIRECTION, (Codec)Direction.CODEC, (Object)this.growthDirection);
        valueOutput.putInt(TAG_GROWTH_DISTANCE, this.growthDistance);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        if (this.sourceState != null) {
            tag.put(TAG_BLOCK_STATE_SOURCE, (Tag)NbtUtils.writeBlockState((BlockState)this.sourceState));
        }
        return tag;
    }

    public BlockState getSourceBlockState() {
        return this.sourceState;
    }

    public boolean shouldRenderFace(Direction direction) {
        BlockPos blockPos = this.getBlockPos();
        BlockState neighborBlockState = this.getLevel().getBlockState(blockPos.relative(direction));
        return !Block.shouldRenderFace((BlockState)this.getBlockState(), (BlockState)neighborBlockState, (Direction)direction);
    }

    public void serverTick() {
        if (this.sourceState == null) {
            this.getLevel().removeBlock(this.getBlockPos(), false);
        } else if (this.lifetimeTicks <= 0) {
            BlockEntity blockEntity;
            this.getLevel().setBlock(this.getBlockPos(), this.sourceState, 3);
            if (this.blockEntityTag != null && (blockEntity = this.getLevel().getBlockEntity(this.getBlockPos())) != null) {
                ValueSerializationHelper.load((ProblemReporter.PathElement)this.problemPath(), (HolderLookup.Provider)this.getLevel().registryAccess(), (CompoundTag)this.blockEntityTag, arg_0 -> ((BlockEntity)blockEntity).loadWithComponents(arg_0));
            }
            if (((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).visuals.particlesForReappearingBlocks) {
                this.getLevel().levelEvent(2001, this.getBlockPos(), Block.getId((BlockState)this.sourceState));
            }
        } else {
            --this.lifetimeTicks;
            TemporaryHoleBlockEntity.tryGrowInDirection(this.getLevel(), this.getBlockPos(), this);
        }
    }

    private static void tryGrowInDirection(Level level, BlockPos pos, TemporaryHoleBlockEntity blockEntity) {
        if (blockEntity.growthDistance > 0 && blockEntity.growthDirection != null) {
            TemporaryHoleBlockEntity.setTemporaryHoleBlock(level, pos.relative(blockEntity.growthDirection), blockEntity.growthDirection, blockEntity.growthDistance - 1);
            blockEntity.growthDistance = 0;
            blockEntity.growthDirection = null;
        }
    }

    public static boolean setTemporaryHoleBlock(Level level, BlockPos blockPos, Direction growthDirection, int growthDistance) {
        if (TemporaryHoleBlockEntity.isValidHolePosition(level, blockPos)) {
            BlockEntity blockEntity;
            boolean replaceBlock;
            BlockEntity blockEntity2;
            BlockState state = level.getBlockState(blockPos);
            CompoundTag blockEntityTag = null;
            if (((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).replaceBlockEntities && (blockEntity2 = level.getBlockEntity(blockPos)) != null) {
                blockEntityTag = blockEntity2.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            }
            boolean bl = replaceBlock = !state.is((Block)ModRegistry.TEMPORARY_HOLE_BLOCK.value());
            if (replaceBlock) {
                level.setBlock(blockPos, ((Block)ModRegistry.TEMPORARY_HOLE_BLOCK.value()).defaultBlockState(), 3);
            }
            if ((blockEntity = level.getBlockEntity(blockPos)) instanceof TemporaryHoleBlockEntity) {
                TemporaryHoleBlockEntity blockEntity3 = (TemporaryHoleBlockEntity)blockEntity;
                if (replaceBlock) {
                    blockEntity3.sourceState = state;
                    blockEntity3.blockEntityTag = blockEntityTag;
                }
                blockEntity3.growthDirection = growthDirection;
                blockEntity3.growthDistance = growthDistance;
                blockEntity3.lifetimeTicks = ((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).temporaryHoleDuration;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidHolePosition(Level level, BlockPos blockPos) {
        BlockState blockState = level.getBlockState(blockPos);
        if (level.hasChunkAt(blockPos) && level.isInWorldBounds(blockPos)) {
            if (blockState.is((Block)ModRegistry.TEMPORARY_HOLE_BLOCK.value())) {
                return true;
            }
            if (!(blockState.isAir() || blockState.hasBlockEntity() && !((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).replaceBlockEntities || blockState.is(ModRegistry.PORTABLE_HOLE_IMMUNE_BLOCK_TAG))) {
                Block block = blockState.getBlock();
                if (block instanceof DoublePlantBlock || block instanceof DoorBlock || block instanceof BedBlock) {
                    return false;
                }
                float destroySpeed = blockState.getDestroySpeed((BlockGetter)level, blockPos);
                return destroySpeed != -1.0f && (double)destroySpeed <= ((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).maxBlockHardness;
            }
        }
        return false;
    }
}

