/*
 * Decompiled with CFR 0.152.
 */
package fuzs.portablehole.client.particle;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import fuzs.portablehole.PortableHole;
import fuzs.portablehole.config.ClientConfig;
import fuzs.portablehole.core.particles.SparkleParticleOptions;
import java.util.Objects;
import net.minecraft.class_1059;
import net.minecraft.class_10799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;

public class SparkleParticle
extends class_3940 {
    public static final RenderPipeline SPARKLE_PARTICLE_RENDER_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56861}).withLocation(PortableHole.id("pipeline/sparkle_particle")).withBlend(BlendFunction.LIGHTNING).build();
    public static final class_3940.class_11941 SPARKLE_PARTICLE_LAYER = new class_3940.class_11941(true, class_1059.field_17898, SPARKLE_PARTICLE_RENDER_PIPELINE);
    private final boolean corrupt;
    private final boolean fake;
    private final boolean slowdown = true;
    private final class_4002 sprites;

    public SparkleParticle(class_638 clientLevel, double x, double y, double z, float size, float red, float green, float blue, int m, boolean fake, boolean noClip, boolean corrupt, class_4002 sprites) {
        super(clientLevel, x, y, z, 0.0, 0.0, 0.0, sprites.method_74304());
        this.field_62633 = red;
        this.field_62634 = green;
        this.field_62635 = blue;
        this.field_62636 = 0.75f;
        this.field_3844 = 0.0f;
        this.field_3850 = 0.0;
        this.field_3869 = 0.0;
        this.field_3852 = 0.0;
        this.field_17867 = (this.field_3840.method_43057() * 0.5f + 0.5f) * 0.2f * size;
        this.field_3847 = 3 * m;
        this.method_3080(0.01f, 0.01f);
        this.field_3858 = x;
        this.field_3838 = y;
        this.field_3856 = z;
        this.fake = fake;
        this.corrupt = corrupt;
        this.field_3862 = !fake && !noClip;
        this.sprites = sprites;
        this.method_74306(sprites);
    }

    public float method_18132(float partialTicks) {
        return this.field_17867 * (float)(this.field_3847 - this.field_3866 + 1) / (float)this.field_3847;
    }

    public void method_3070() {
        this.method_74306(this.sprites);
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        }
        this.field_3869 -= 0.04 * (double)this.field_3844;
        if (this.field_3862 && !this.fake) {
            this.wiggleAround(this.field_3874, (this.method_3064().field_1322 + this.method_3064().field_1325) / 2.0, this.field_3871);
        }
        this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        Objects.requireNonNull(this);
        this.field_3852 *= 0.908;
        this.field_3869 *= 0.908;
        this.field_3850 *= 0.908;
        if (this.field_3845) {
            this.field_3852 *= 0.7;
            this.field_3850 *= 0.7;
        }
        if (this.fake && this.field_3866 > 1) {
            this.method_3085();
        }
    }

    protected class_3940.class_11941 method_74255() {
        if (((ClientConfig)PortableHole.CONFIG.get(ClientConfig.class)).opaqueSparkleParticles) {
            return class_3940.class_11941.field_62640;
        }
        return SPARKLE_PARTICLE_LAYER;
    }

    public void setGravity(float value) {
        this.field_3844 = value;
    }

    private void wiggleAround(double x, double y, double z) {
        class_2338 blockpos = class_2338.method_49637((double)x, (double)y, (double)z);
        class_243 Vector3d = new class_243(x - (double)blockpos.method_10263(), y - (double)blockpos.method_10264(), z - (double)blockpos.method_10260());
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
        class_2350 direction = class_2350.field_11036;
        double d0 = Double.MAX_VALUE;
        for (class_2350 direction1 : new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034, class_2350.field_11036}) {
            double d2;
            blockpos$mutable.method_10101((class_2382)blockpos).method_10098(direction1);
            if (this.field_3851.method_8320((class_2338)blockpos$mutable).method_26234((class_1922)this.field_3851, (class_2338)blockpos$mutable)) continue;
            double d1 = Vector3d.method_18043(direction1.method_10166());
            double d = d2 = direction1.method_10171() == class_2350.class_2352.field_11056 ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.field_3840.method_43057() * 0.05f + 0.025f;
        float f1 = direction.method_10171().method_10181();
        float secondary = (this.field_3840.method_43057() - this.field_3840.method_43057()) * 0.1f;
        float secondary2 = (this.field_3840.method_43057() - this.field_3840.method_43057()) * 0.1f;
        if (direction.method_10166() == class_2350.class_2351.field_11048) {
            this.field_3852 = f1 * f;
            this.field_3869 = secondary;
            this.field_3850 = secondary2;
        } else if (direction.method_10166() == class_2350.class_2351.field_11052) {
            this.field_3852 = secondary;
            this.field_3869 = f1 * f;
            this.field_3850 = secondary2;
        } else if (direction.method_10166() == class_2350.class_2351.field_11051) {
            this.field_3852 = secondary;
            this.field_3869 = secondary2;
            this.field_3850 = f1 * f;
        }
    }

    public static class Factory
    implements class_707<SparkleParticleOptions> {
        private final class_4002 sprites;

        public Factory(class_4002 sprites) {
            this.sprites = sprites;
        }

        public class_703 createParticle(SparkleParticleOptions data, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_5819 randomSource) {
            return new SparkleParticle(level, x, y, z, data.size, data.r, data.g, data.b, data.m, data.fake, data.noClip, data.corrupt, this.sprites);
        }
    }
}

