/*
 * Decompiled with CFR 0.152.
 */
package fuzs.portablehole.world.level.block.entity;

import com.mojang.serialization.Codec;
import fuzs.portablehole.PortableHole;
import fuzs.portablehole.config.ServerConfig;
import fuzs.portablehole.init.ModRegistry;
import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.puzzleslib.api.util.v1.ValueSerializationHelper;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.jetbrains.annotations.Nullable;

public class TemporaryHoleBlockEntity
extends class_2586
implements TickingBlockEntity {
    public static final String TAG_BLOCK_STATE_SOURCE = PortableHole.id("source_state").toString();
    public static final String TAG_BLOCK_ENTITY_SOURCE_TAG = PortableHole.id("source_block_entity_tag").toString();
    public static final String TAG_LIFETIME_TICKS = PortableHole.id("lifetime_ticks").toString();
    public static final String TAG_GROWTH_DIRECTION = PortableHole.id("growth_direction").toString();
    public static final String TAG_GROWTH_DISTANCE = PortableHole.id("growth_distance").toString();
    private class_2680 sourceState;
    @Nullable
    private class_2487 blockEntityTag;
    private int lifetimeTicks;
    @Nullable
    private class_2350 growthDirection;
    private int growthDistance;

    public TemporaryHoleBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModRegistry.TEMPORARY_HOLE_BLOCK_ENTITY_TYPE.comp_349(), pos, state);
    }

    protected void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        this.sourceState = valueInput.method_71426(TAG_BLOCK_STATE_SOURCE, class_2680.field_24734).filter(Predicate.not(class_4970.class_4971::method_26215)).orElse(null);
        this.blockEntityTag = valueInput.method_71426(TAG_BLOCK_ENTITY_SOURCE_TAG, class_2487.field_25128).orElse(null);
        this.lifetimeTicks = valueInput.method_71424(TAG_LIFETIME_TICKS, 0);
        this.growthDirection = valueInput.method_71426(TAG_GROWTH_DIRECTION, (Codec)class_2350.field_29502).orElse(null);
        this.growthDistance = valueInput.method_71424(TAG_GROWTH_DISTANCE, 0);
    }

    protected void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        valueOutput.method_71477(TAG_BLOCK_STATE_SOURCE, class_2680.field_24734, (Object)this.sourceState);
        valueOutput.method_71477(TAG_BLOCK_ENTITY_SOURCE_TAG, class_2487.field_25128, (Object)this.blockEntityTag);
        valueOutput.method_71465(TAG_LIFETIME_TICKS, this.lifetimeTicks);
        valueOutput.method_71477(TAG_GROWTH_DIRECTION, (Codec)class_2350.field_29502, (Object)this.growthDirection);
        valueOutput.method_71465(TAG_GROWTH_DISTANCE, this.growthDistance);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 tag = super.method_16887(registries);
        if (this.sourceState != null) {
            tag.method_10566(TAG_BLOCK_STATE_SOURCE, (class_2520)class_2512.method_10686((class_2680)this.sourceState));
        }
        return tag;
    }

    public class_2680 getSourceBlockState() {
        return this.sourceState;
    }

    public boolean shouldRenderFace(class_2350 direction) {
        class_2338 blockPos = this.method_11016();
        class_2680 neighborBlockState = this.method_10997().method_8320(blockPos.method_10093(direction));
        return !class_2248.method_9607((class_2680)this.method_11010(), (class_2680)neighborBlockState, (class_2350)direction);
    }

    public void serverTick() {
        if (this.sourceState == null) {
            this.method_10997().method_8650(this.method_11016(), false);
        } else if (this.lifetimeTicks <= 0) {
            class_2586 blockEntity;
            this.method_10997().method_8652(this.method_11016(), this.sourceState, 3);
            if (this.blockEntityTag != null && (blockEntity = this.method_10997().method_8321(this.method_11016())) != null) {
                ValueSerializationHelper.load((class_8942.class_11336)this.method_71402(), (class_7225.class_7874)this.method_10997().method_30349(), (class_2487)this.blockEntityTag, arg_0 -> ((class_2586)blockEntity).method_58690(arg_0));
            }
            if (((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).visuals.particlesForReappearingBlocks) {
                this.method_10997().method_20290(2001, this.method_11016(), class_2248.method_9507((class_2680)this.sourceState));
            }
        } else {
            --this.lifetimeTicks;
            TemporaryHoleBlockEntity.tryGrowInDirection(this.method_10997(), this.method_11016(), this);
        }
    }

    private static void tryGrowInDirection(class_1937 level, class_2338 pos, TemporaryHoleBlockEntity blockEntity) {
        if (blockEntity.growthDistance > 0 && blockEntity.growthDirection != null) {
            TemporaryHoleBlockEntity.setTemporaryHoleBlock(level, pos.method_10093(blockEntity.growthDirection), blockEntity.growthDirection, blockEntity.growthDistance - 1);
            blockEntity.growthDistance = 0;
            blockEntity.growthDirection = null;
        }
    }

    public static boolean setTemporaryHoleBlock(class_1937 level, class_2338 blockPos, class_2350 growthDirection, int growthDistance) {
        if (TemporaryHoleBlockEntity.isValidHolePosition(level, blockPos)) {
            class_2586 class_25862;
            boolean replaceBlock;
            class_2586 blockEntity;
            class_2680 state = level.method_8320(blockPos);
            class_2487 blockEntityTag = null;
            if (((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).replaceBlockEntities && (blockEntity = level.method_8321(blockPos)) != null) {
                blockEntityTag = blockEntity.method_38244((class_7225.class_7874)level.method_30349());
            }
            boolean bl = replaceBlock = !state.method_27852((class_2248)ModRegistry.TEMPORARY_HOLE_BLOCK.comp_349());
            if (replaceBlock) {
                level.method_8652(blockPos, ((class_2248)ModRegistry.TEMPORARY_HOLE_BLOCK.comp_349()).method_9564(), 3);
            }
            if ((class_25862 = level.method_8321(blockPos)) instanceof TemporaryHoleBlockEntity) {
                TemporaryHoleBlockEntity blockEntity2 = (TemporaryHoleBlockEntity)class_25862;
                if (replaceBlock) {
                    blockEntity2.sourceState = state;
                    blockEntity2.blockEntityTag = blockEntityTag;
                }
                blockEntity2.growthDirection = growthDirection;
                blockEntity2.growthDistance = growthDistance;
                blockEntity2.lifetimeTicks = ((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).temporaryHoleDuration;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidHolePosition(class_1937 level, class_2338 blockPos) {
        class_2680 blockState = level.method_8320(blockPos);
        if (level.method_22340(blockPos) && level.method_24794(blockPos)) {
            if (blockState.method_27852((class_2248)ModRegistry.TEMPORARY_HOLE_BLOCK.comp_349())) {
                return true;
            }
            if (!(blockState.method_26215() || blockState.method_31709() && !((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).replaceBlockEntities || blockState.method_26164(ModRegistry.PORTABLE_HOLE_IMMUNE_BLOCK_TAG))) {
                class_2248 block = blockState.method_26204();
                if (block instanceof class_2320 || block instanceof class_2323 || block instanceof class_2244) {
                    return false;
                }
                float destroySpeed = blockState.method_26214((class_1922)level, blockPos);
                return destroySpeed != -1.0f && (double)destroySpeed <= ((ServerConfig)PortableHole.CONFIG.get(ServerConfig.class)).maxBlockHardness;
            }
        }
        return false;
    }
}

