/*
 * Decompiled with CFR 0.152.
 */
package at.blaxk.nolocatorbar;

import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class NoLocatorBar
extends JavaPlugin {
    public void onEnable() {
        new BukkitRunnable(){

            public void run() {
                NoLocatorBar.this.disableLocatorBarInAllWorlds();
            }
        }.runTaskLater((Plugin)this, 1L);
    }

    private void disableLocatorBarInAllWorlds() {
        try {
            GameRule locatorBarRule = GameRule.LOCATOR_BAR;
            for (World world : Bukkit.getWorlds()) {
                try {
                    world.setGameRule(locatorBarRule, (Object)false);
                }
                catch (Exception e) {
                    this.getLogger().warning("Failed to disable locator bar in world " + world.getName() + ": " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to access locator bar gamerule: " + e.getMessage());
            this.fallbackDisableLocatorBar();
        }
    }

    private void fallbackDisableLocatorBar() {
        for (World world : Bukkit.getWorlds()) {
            try {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("gamerule locatorBar false " + world.getName()));
            }
            catch (Exception e) {
                this.getLogger().warning("Fallback failed for world " + world.getName() + ": " + e.getMessage());
            }
        }
    }
}

