/*
 * Decompiled with CFR 0.152.
 */
package com.blaxk.nolocatorbar;

import com.blaxk.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class NoLocatorBar
extends JavaPlugin {
    public void onEnable() {
        int pluginId = 26757;
        new Metrics(this, pluginId);
        if (NoLocatorBar.isFolia()) {
            try {
                Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this, task -> this.disableLocatorBarInAllWorlds(), 1L);
            }
            catch (Throwable t) {
                this.getLogger().warning("Folia scheduling failed: " + t.getMessage());
                this.disableLocatorBarInAllWorlds();
            }
        } else {
            Bukkit.getScheduler().runTask((Plugin)this, this::disableLocatorBarInAllWorlds);
        }
    }

    private void disableLocatorBarInAllWorlds() {
        GameRule locatorBarRule = GameRule.LOCATOR_BAR;
        for (World world : Bukkit.getWorlds()) {
            try {
                world.setGameRule(locatorBarRule, (Object)false);
                this.getLogger().info("Disabled locator-bar in world: " + world.getName());
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to disable locator-bar in world \"" + world.getName() + "\": " + e.getMessage());
            }
        }
    }

    private static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }
}

