/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.addon.advancedstats;

import com.nsr.ai.addon.advancedstats.PlayerData;
import com.nsr.ai.addon.advancedstats.PlayerDataManager;
import com.nsr.ai.addon.advancedstats.PrivacyManager;
import com.nsr.ai.addon.advancedstats.util.StringUtil;
import com.nsr.ai.plugin.addons.Addon;
import com.nsr.ai.plugin.api.NSRaiAPI;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AdvancedPlayerStatsAddon
implements Addon,
Listener {
    private NSRaiAPI api;
    private String addonName;
    private String addonVersion = "1.0.2";
    private PlayerDataManager playerDataManager;
    private PrivacyManager privacyManager;
    private final Map<String, String> statKeywords = new HashMap<String, String>();
    private final Map<UUID, Long> lastActivity = new HashMap<UUID, Long>();

    @Override
    public void onEnable(NSRaiAPI api) {
        this.api = api;
        this.addonName = "NSR-AI-Advanced-Player-Stats";
        this.addonVersion = "1.0";
        this.api.getLogger().info("Successfully hooked into NSR-AI for addon: " + this.addonName);
        File dataFolder = new File(new File(api.getPlugin().getDataFolder(), "addons"), this.getName());
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        this.playerDataManager = new PlayerDataManager(api, dataFolder);
        this.privacyManager = new PrivacyManager(dataFolder);
        this.api.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, this.api.getPlugin());
        this.initializeStatKeywords();
        this.startUpdateTask();
    }

    private String getPermissionDeniedMessageCompat() {
        try {
            Method method = this.api.getClass().getMethod("getPermissionDeniedMessage", new Class[0]);
            return (String)method.invoke((Object)this.api, new Object[0]);
        }
        catch (Exception e) {
            try {
                Plugin plugin = this.api.getPlugin();
                Method method = plugin.getClass().getMethod("getPermissionDeniedMessage", new Class[0]);
                return (String)method.invoke((Object)plugin, new Object[0]);
            }
            catch (Exception ex) {
                return "&cYou do not have permission to do that.";
            }
        }
    }

    private String colorizeCompat(String message) {
        try {
            Method method = this.api.getClass().getMethod("colorize", String.class);
            return (String)method.invoke((Object)this.api, message);
        }
        catch (Exception e) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        }
    }

    private void startUpdateTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    PlayerData data;
                    if (AdvancedPlayerStatsAddon.this.isAfk(player.getUniqueId())) {
                        data = AdvancedPlayerStatsAddon.this.playerDataManager.getPlayerData((OfflinePlayer)player);
                        data.setTotalAfkTime(data.getTotalAfkTime() + 1L);
                        AdvancedPlayerStatsAddon.this.playerDataManager.savePlayerData((OfflinePlayer)player, data);
                        AdvancedPlayerStatsAddon.this.sendAfkNotification(player);
                        continue;
                    }
                    data = AdvancedPlayerStatsAddon.this.playerDataManager.getPlayerData((OfflinePlayer)player);
                    data.setTimePlayed(data.getTimePlayed() + 1L);
                    AdvancedPlayerStatsAddon.this.playerDataManager.savePlayerData((OfflinePlayer)player, data);
                }
            }
        }.runTaskTimerAsynchronously(this.api.getPlugin(), 1200L, 1200L);
    }

    private void sendAfkNotification(Player afkPlayer) {
        List<String> recipients = this.privacyManager.getAdminRecipients();
        String message = this.colorizeCompat("&e[AFK] &f" + afkPlayer.getName() + " has been AFK for " + this.privacyManager.getAfkTimer() + " minutes.");
        for (String recipient : recipients) {
            if (recipient.equalsIgnoreCase("CONSOLE")) {
                Bukkit.getConsoleSender().sendMessage(message);
                continue;
            }
            Player admin = Bukkit.getPlayer((String)recipient);
            if (admin == null) continue;
            admin.sendMessage(message);
        }
    }

    private void initializeStatKeywords() {
        this.statKeywords.put("health", "health");
        this.statKeywords.put("hp", "health");
        this.statKeywords.put("hunger", "hunger");
        this.statKeywords.put("location", "location");
        this.statKeywords.put("loc", "location");
        this.statKeywords.put("playtime", "playtime");
        this.statKeywords.put("deaths", "deaths");
        this.statKeywords.put("kills", "kills");
        this.statKeywords.put("kd", "kd");
        this.statKeywords.put("kdr", "kd");
        this.statKeywords.put("blocks_mined", "blocks_mined");
        this.statKeywords.put("blocks_placed", "blocks_placed");
        this.statKeywords.put("distance_traveled", "distance_traveled");
        this.statKeywords.put("streak", "streak");
        this.statKeywords.put("afk", "afk");
        this.statKeywords.put("afktime", "afktime");
        this.statKeywords.put("all", "all");
        this.statKeywords.put("stats", "all");
    }

    @Override
    public String onCommand(Player player, String[] args) {
        String message = String.join((CharSequence)" ", args).toLowerCase();
        if (args.length > 0 && args[0].equalsIgnoreCase("help") && args.length > 1 && args[1].equalsIgnoreCase("stats")) {
            return this.getStatsHelp();
        }
        if (args.length > 1 && args[0].equalsIgnoreCase("privacy")) {
            return this.handlePrivacyCommand(player, args);
        }
        List<String> statRequestKeywords = Arrays.asList("stats", "all", "health", "hp", "hunger", "location", "loc", "playtime", "deaths", "kills", "kd", "kdr", "blocks_mined", "blocks_placed", "distance_traveled", "streak", "afk", "afktime");
        boolean containsStatRequest = false;
        for (String arg : args) {
            if (!statRequestKeywords.contains(arg)) continue;
            containsStatRequest = true;
            break;
        }
        if (!containsStatRequest) {
            return null;
        }
        String requestedStat = null;
        String playerName = null;
        for (String arg : args) {
            if (this.statKeywords.containsKey(arg)) {
                requestedStat = this.statKeywords.get(arg);
                continue;
            }
            playerName = arg;
        }
        if (playerName != null) {
            OfflinePlayer targetPlayer = StringUtil.findBestPlayerMatch(playerName, 2);
            if (targetPlayer != null) {
                if (requestedStat != null) {
                    return this.handleStatsCommand(player, targetPlayer, requestedStat);
                }
                return this.getAllStats(targetPlayer);
            }
            return this.colorizeCompat("&cPlayer not found: " + playerName);
        }
        return null;
    }

    private String getStatsHelp() {
        StringBuilder help = new StringBuilder();
        help.append(this.colorizeCompat("&a&l--- Player Stats Commands ---")).append("\n");
        help.append(this.colorizeCompat("&b/ai stats <player> &7- Shows all stats for a player.")).append("\n");
        help.append(this.colorizeCompat("&b/ai <stat> <player> &7- Shows a specific stat for a player.")).append("\n");
        help.append(this.colorizeCompat("&b/ai privacy <player> <feature> [on|off] &7- Toggles a privacy setting for a player.")).append("\n");
        help.append(this.colorizeCompat("&a&l--- Available Stats ---")).append("\n");
        help.append(this.colorizeCompat("&b- health, hunger, playtime, deaths, kills, kd, blocks_mined, blocks_placed, distance_traveled, streak, afk, afktime, location"));
        return help.toString();
    }

    private String handlePrivacyCommand(Player player, String[] args) {
        String feature;
        Player targetPlayer;
        String value = null;
        boolean isAdmin = player.hasPermission("nsr-ai.admin.privacy");
        if (isAdmin) {
            if (args.length < 2) {
                return this.colorizeCompat("&cUsage: /ai privacy <feature> [on|off] (for self) or /ai privacy <player> <feature> [on|off] (for others)");
            }
            OfflinePlayer potentialTarget = StringUtil.findBestPlayerMatch(args[1], 2);
            if (potentialTarget != null && args.length >= 3) {
                targetPlayer = potentialTarget;
                feature = args[2];
                if (args.length > 3) {
                    value = args[3];
                }
            } else {
                targetPlayer = player;
                feature = args[1];
                if (args.length > 2) {
                    value = args[2];
                }
            }
        } else {
            targetPlayer = player;
            if (args.length < 2) {
                return this.colorizeCompat("&cUsage: /ai privacy <feature> [on|off]");
            }
            feature = args[1];
            if (args.length > 2) {
                value = args[2];
            }
        }
        String bestMatch = StringUtil.findBestMatch(feature, this.privacyManager.getAllFeatures());
        if (bestMatch == null) {
            return this.colorizeCompat("&cUnknown privacy feature: " + feature);
        }
        boolean enabled = value != null ? value.equalsIgnoreCase("on") : !this.privacyManager.isFeatureEnabled((OfflinePlayer)targetPlayer, bestMatch);
        this.privacyManager.setFeatureEnabled((OfflinePlayer)targetPlayer, bestMatch, enabled);
        return this.colorizeCompat("&aPrivacy setting for '" + bestMatch + "' for " + targetPlayer.getName() + " has been set to " + (enabled ? "ON" : "OFF") + ".");
    }

    private String handleStatsCommand(Player requester, OfflinePlayer targetPlayer, String stat) {
        if ("all".equals(stat)) {
            return this.getAllStats(targetPlayer);
        }
        if (!this.privacyManager.isFeatureEnabled(targetPlayer, stat) && !requester.hasPermission("nsr-ai.admin.privacy.bypass")) {
            return this.colorizeCompat("&c" + targetPlayer.getName() + "'s " + stat + " data is private.");
        }
        PlayerData data = this.playerDataManager.getPlayerData(targetPlayer);
        String response = "&b" + stat + ": &f" + this.getSingleStat(data, targetPlayer, stat);
        return this.colorizeCompat("&a&l--- Player Stats for " + targetPlayer.getName() + " ---") + "\n" + this.colorizeCompat(response);
    }

    private String getAllStats(OfflinePlayer targetPlayer) {
        StringBuilder response = new StringBuilder();
        response.append(this.colorizeCompat("&a&l--- Player Stats for ")).append(targetPlayer.getName()).append(this.colorizeCompat(" ---")).append("\n");
        PlayerData data = this.playerDataManager.getPlayerData(targetPlayer);
        for (String feature : this.privacyManager.getAllFeatures()) {
            if ("stats".equals(feature)) continue;
            boolean isPrivate = !this.privacyManager.isFeatureEnabled(targetPlayer, feature);
            response.append(this.colorizeCompat("&b" + feature + ": "));
            if (isPrivate) {
                response.append(this.colorizeCompat("&cPrivate"));
            } else {
                response.append(this.colorizeCompat("&f" + this.getSingleStat(data, targetPlayer, feature)));
            }
            response.append(this.colorizeCompat(" (&e" + this.privacyManager.getPrivacyStatus(targetPlayer, feature) + "&e)"));
            response.append("\n");
        }
        return response.toString();
    }

    private String getSingleStat(PlayerData data, OfflinePlayer targetPlayer, String stat) {
        switch (stat) {
            case "health": {
                if (targetPlayer.isOnline() && targetPlayer.getPlayer() != null) {
                    return String.format("&a%.2f / %.2f", targetPlayer.getPlayer().getHealth(), targetPlayer.getPlayer().getMaxHealth());
                }
                return "&cPlayer is offline.";
            }
            case "hunger": {
                if (targetPlayer.isOnline() && targetPlayer.getPlayer() != null) {
                    return "&e" + String.valueOf(targetPlayer.getPlayer().getFoodLevel());
                }
                return "&cPlayer is offline.";
            }
            case "playtime": {
                return "&e" + StringUtil.formatDuration(data.getTimePlayed());
            }
            case "afktime": {
                if (data.getTotalAfkTime() == 0L) {
                    return "&e0 afk record";
                }
                return "&e" + StringUtil.formatDuration(data.getTotalAfkTime());
            }
            case "deaths": {
                return "&c" + String.valueOf(data.getTimesKilled());
            }
            case "kills": {
                return "&a" + String.valueOf(data.getPlayersKilled());
            }
            case "kd": {
                return "&e" + String.format("%.2f", data.getTimesKilled() == 0 ? (double)data.getPlayersKilled() : (double)data.getPlayersKilled() / (double)data.getTimesKilled());
            }
            case "blocks_mined": {
                return "&e" + String.valueOf(data.getBlocksBroken());
            }
            case "blocks_placed": {
                return "&e" + String.valueOf(data.getBlocksPlaced());
            }
            case "distance_traveled": {
                return "&e" + String.valueOf(data.getDistanceTraveled()) + " blocks";
            }
            case "streak": {
                return "&e" + String.valueOf(data.getPvpStreak());
            }
            case "afk": {
                if (this.isAfk(targetPlayer.getUniqueId())) {
                    return "&cYes (" + StringUtil.formatDuration(data.getTotalAfkTime()) + ")";
                }
                return "&aNo";
            }
            case "location": {
                if (targetPlayer.isOnline() && targetPlayer.getPlayer() != null) {
                    Location loc = targetPlayer.getPlayer().getLocation();
                    String worldName = loc.getWorld().getName();
                    String dimension = "";
                    switch (loc.getWorld().getEnvironment()) {
                        case NORMAL: {
                            dimension = "Overworld";
                            break;
                        }
                        case NETHER: {
                            dimension = "Nether";
                            break;
                        }
                        case THE_END: {
                            dimension = "The End";
                        }
                    }
                    return String.format("&eWorld: %s (%s)", worldName, dimension);
                }
                long lastPlayed = targetPlayer.getLastPlayed();
                long now = System.currentTimeMillis();
                long diff = now - lastPlayed;
                String lastSeen = StringUtil.formatTime(diff);
                return String.format("&eLast seen: %s ago", lastSeen);
            }
        }
        return "&cN/A";
    }

    public boolean isAfk(UUID uuid) {
        long afkTimeMillis = this.privacyManager.getAfkTimer() * 60 * 1000;
        return System.currentTimeMillis() - this.lastActivity.getOrDefault(uuid, System.currentTimeMillis()) > afkTimeMillis;
    }

    @Override
    public void onDisable() {
        if (this.api != null) {
            this.api.getLogger().info(this.getName() + " has been disabled.");
        }
    }

    @Override
    public String getName() {
        return this.addonName;
    }

    @Override
    public String getVersion() {
        return this.addonVersion;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        this.lastActivity.put(event.getPlayer().getUniqueId(), System.currentTimeMillis());
        PlayerData data = this.playerDataManager.getPlayerData((OfflinePlayer)event.getPlayer());
        double distance = event.getFrom().toVector().setY(0).distance(event.getTo().toVector().setY(0));
        if (distance > 0.0) {
            data.setDistanceTraveled(data.getDistanceTraveled() + (long)distance);
            this.playerDataManager.savePlayerData((OfflinePlayer)event.getPlayer(), data);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        this.lastActivity.put(event.getPlayer().getUniqueId(), System.currentTimeMillis());
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        this.lastActivity.put(event.getPlayer().getUniqueId(), System.currentTimeMillis());
        PlayerData data = this.playerDataManager.getPlayerData((OfflinePlayer)event.getPlayer());
        data.setBlocksBroken(data.getBlocksBroken() + 1L);
        this.playerDataManager.savePlayerData((OfflinePlayer)event.getPlayer(), data);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        this.lastActivity.put(event.getPlayer().getUniqueId(), System.currentTimeMillis());
        PlayerData data = this.playerDataManager.getPlayerData((OfflinePlayer)event.getPlayer());
        data.setBlocksPlaced(data.getBlocksPlaced() + 1L);
        this.playerDataManager.savePlayerData((OfflinePlayer)event.getPlayer(), data);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.lastActivity.put(event.getPlayer().getUniqueId(), System.currentTimeMillis());
        PlayerData data = this.playerDataManager.getPlayerData((OfflinePlayer)event.getPlayer());
        data.setTimesJoined(data.getTimesJoined() + 1);
        this.playerDataManager.savePlayerData((OfflinePlayer)event.getPlayer(), data);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        this.lastActivity.put(event.getEntity().getUniqueId(), System.currentTimeMillis());
        PlayerData killedData = this.playerDataManager.getPlayerData((OfflinePlayer)event.getEntity());
        killedData.setTimesKilled(killedData.getTimesKilled() + 1);
        killedData.setPvpStreak(0);
        this.playerDataManager.savePlayerData((OfflinePlayer)event.getEntity(), killedData);
        if (event.getEntity().getKiller() != null) {
            Player killer = event.getEntity().getKiller();
            PlayerData killerData = this.playerDataManager.getPlayerData((OfflinePlayer)killer);
            killerData.setPlayersKilled(killerData.getPlayersKilled() + 1);
            killerData.setPvpStreak(killerData.getPvpStreak() + 1);
            this.playerDataManager.savePlayerData((OfflinePlayer)killer, killerData);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.lastActivity.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            PlayerData data = this.playerDataManager.getPlayerData((OfflinePlayer)player);
            data.setHealth(player.getHealth() - event.getFinalDamage());
            this.playerDataManager.savePlayerData((OfflinePlayer)player, data);
        }
    }

    @Override
    public Map<String, String> getCommands() {
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, String> getFeatures() {
        return new HashMap<String, String>();
    }
}

