/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.addon.advancedstats;

import com.nsr.ai.addon.advancedstats.PlayerData;
import com.nsr.ai.plugin.api.NSRaiAPI;
import java.io.File;
import java.io.IOException;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerDataManager {
    private final NSRaiAPI api;
    private final File playerDataFolder;

    public PlayerDataManager(NSRaiAPI api, File dataFolder) {
        this.api = api;
        this.playerDataFolder = new File(dataFolder, "playerdata");
        if (!this.playerDataFolder.exists()) {
            this.playerDataFolder.mkdirs();
        }
    }

    public PlayerData getPlayerData(OfflinePlayer player) {
        File playerFile = new File(this.playerDataFolder, player.getUniqueId().toString() + ".yml");
        if (!playerFile.exists()) {
            return new PlayerData(player.getName());
        }
        YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
        PlayerData data = new PlayerData(player.getName());
        data.setTimePlayed(playerConfig.getLong("timePlayed"));
        data.setTimesJoined(playerConfig.getInt("timesJoined"));
        data.setHealth(playerConfig.getDouble("health"));
        data.setTimesKilled(playerConfig.getInt("timesKilled"));
        data.setPlayersKilled(playerConfig.getInt("playersKilled"));
        data.setBlocksBroken(playerConfig.getLong("blocksBroken"));
        data.setBlocksPlaced(playerConfig.getLong("blocksPlaced"));
        data.setDistanceTraveled(playerConfig.getLong("distanceTraveled"));
        data.setPvpStreak(playerConfig.getInt("pvpStreak"));
        data.setTotalAfkTime(playerConfig.getLong("totalAfkTime"));
        return data;
    }

    public void savePlayerData(OfflinePlayer player, PlayerData data) {
        File playerFile = new File(this.playerDataFolder, player.getUniqueId().toString() + ".yml");
        YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
        playerConfig.set("playerName", (Object)data.getPlayerName());
        playerConfig.set("timePlayed", (Object)data.getTimePlayed());
        playerConfig.set("timesJoined", (Object)data.getTimesJoined());
        playerConfig.set("health", (Object)data.getHealth());
        playerConfig.set("timesKilled", (Object)data.getTimesKilled());
        playerConfig.set("playersKilled", (Object)data.getPlayersKilled());
        playerConfig.set("blocksBroken", (Object)data.getBlocksBroken());
        playerConfig.set("blocksPlaced", (Object)data.getBlocksPlaced());
        playerConfig.set("distanceTraveled", (Object)data.getDistanceTraveled());
        playerConfig.set("pvpStreak", (Object)data.getPvpStreak());
        playerConfig.set("totalAfkTime", (Object)data.getTotalAfkTime());
        try {
            playerConfig.save(playerFile);
        }
        catch (IOException e) {
            this.api.getLogger().severe("Could not save player data for " + player.getName());
        }
    }
}

