/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.addon.advancedstats;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class PrivacyManager {
    private final File playerPrivacyFolder;
    private FileConfiguration defaultConfig;

    public PrivacyManager(File dataFolder) {
        this.playerPrivacyFolder = new File(dataFolder, "playerprivacy");
        if (!this.playerPrivacyFolder.exists()) {
            this.playerPrivacyFolder.mkdirs();
        }
        this.loadDefaults();
    }

    private void loadDefaults() {
        InputStream defaultConfigStream = this.getClass().getClassLoader().getResourceAsStream("privacy.yml");
        this.defaultConfig = defaultConfigStream != null ? YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultConfigStream)) : new YamlConfiguration();
    }

    private File getPlayerFile(OfflinePlayer player) {
        return new File(this.playerPrivacyFolder, player.getName() + "-" + player.getUniqueId().toString() + ".yml");
    }

    private FileConfiguration getPlayerConfig(OfflinePlayer player) {
        File playerFile = this.getPlayerFile(player);
        if (!playerFile.exists()) {
            try {
                playerFile.createNewFile();
                YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
                if (this.defaultConfig != null) {
                    playerConfig.setDefaults((Configuration)this.defaultConfig);
                    playerConfig.options().copyDefaults(true);
                    playerConfig.save(playerFile);
                }
                return playerConfig;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new YamlConfiguration();
            }
        }
        return YamlConfiguration.loadConfiguration((File)playerFile);
    }

    public boolean isFeatureEnabled(OfflinePlayer player, String feature) {
        return this.getPlayerConfig(player).getBoolean(feature, this.defaultConfig.getBoolean("default." + feature, true));
    }

    public void setFeatureEnabled(OfflinePlayer player, String feature, boolean enabled) {
        FileConfiguration playerConfig = this.getPlayerConfig(player);
        playerConfig.set(feature, (Object)enabled);
        try {
            playerConfig.save(this.getPlayerFile(player));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getPrivacyStatus(OfflinePlayer player, String feature) {
        return this.isFeatureEnabled(player, feature) ? "&aOn" : "&cOff";
    }

    public List<String> getAllFeatures() {
        return List.of("health", "hunger", "deaths", "kills", "kd", "blocks_mined", "blocks_placed", "distance_traveled", "playtime", "afk", "streak", "location", "stats");
    }

    public int getAfkTimer() {
        return this.defaultConfig.getInt("afk.kick-timer", 8);
    }

    public List<String> getAdminRecipients() {
        return this.defaultConfig.getStringList("admin-recipients");
    }
}

