/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.addon.advancedstats.util;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class StringUtil {
    public static int getLevenshteinDistance(String s1, String s2) {
        int[][] dp = new int[s1.length() + 1][s2.length() + 1];
        for (int i = 0; i <= s1.length(); ++i) {
            for (int j = 0; j <= s2.length(); ++j) {
                dp[i][j] = i == 0 ? j : (j == 0 ? i : StringUtil.min(dp[i - 1][j - 1] + StringUtil.costOfSubstitution(s1.charAt(i - 1), s2.charAt(j - 1)), dp[i - 1][j] + 1, dp[i][j - 1] + 1));
            }
        }
        return dp[s1.length()][s2.length()];
    }

    private static int costOfSubstitution(char a, char b) {
        return a == b ? 0 : 1;
    }

    private static int min(int ... numbers) {
        return Arrays.stream(numbers).min().orElse(Integer.MAX_VALUE);
    }

    public static String findBestMatch(String input, List<String> options) {
        String bestMatch = null;
        int bestDistance = Integer.MAX_VALUE;
        for (String option : options) {
            int distance = StringUtil.getLevenshteinDistance(input, option);
            if (distance >= bestDistance) continue;
            bestDistance = distance;
            bestMatch = option;
        }
        return bestMatch;
    }

    public static OfflinePlayer findBestPlayerMatch(String input, int maxDistance) {
        OfflinePlayer bestMatch = null;
        int bestDistance = Integer.MAX_VALUE;
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            int distance = StringUtil.getLevenshteinDistance(input.toLowerCase(), player.getName().toLowerCase());
            if (distance >= bestDistance || distance > maxDistance) continue;
            bestDistance = distance;
            bestMatch = player;
        }
        return bestMatch;
    }

    public static String formatDuration(long seconds) {
        long days = seconds / 86400L;
        long hours = seconds % 86400L / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        StringBuilder builder = new StringBuilder();
        if (days > 0L) {
            builder.append(days).append(days == 1L ? " day, " : " days, ");
        }
        if (hours > 0L) {
            builder.append(hours).append(hours == 1L ? " hour, " : " hours, ");
        }
        if (minutes > 0L) {
            builder.append(minutes).append(minutes == 1L ? " minute, " : " minutes, ");
        }
        builder.append(secs).append(secs == 1L ? " second" : " seconds");
        return builder.toString();
    }

    public static String formatTime(long millis) {
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + " day(s)";
        }
        if (hours > 0L) {
            return hours + " hour(s)";
        }
        if (minutes > 0L) {
            return minutes + " minute(s)";
        }
        return seconds + " second(s)";
    }
}

