/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.advanced_stats.listeners;

import com.nsr.ai.advanced_stats.managers.AfkManager;
import com.nsr.ai.advanced_stats.managers.StatsManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class StatsListener
implements Listener {
    private final StatsManager statsManager;
    private final AfkManager afkManager;
    private final Map<UUID, Long> joinTimes = new ConcurrentHashMap<UUID, Long>();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public StatsListener(StatsManager statsManager, AfkManager afkManager) {
        this.statsManager = statsManager;
        this.afkManager = afkManager;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.joinTimes.put(player.getUniqueId(), System.currentTimeMillis());
        this.afkManager.updateActivity(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        Long joinTime = this.joinTimes.remove(player.getUniqueId());
        if (joinTime != null) {
            long sessionDurationMillis = System.currentTimeMillis() - joinTime;
            long minutes = sessionDurationMillis / 60000L;
            String sessionInfo = String.format("Logged in at %s, played for %d minutes.", this.dateFormat.format(new Date(joinTime)), minutes);
            this.statsManager.addSessionInfo(player.getUniqueId(), sessionInfo);
        }
        this.afkManager.removePlayer(player);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        this.statsManager.incrementDeaths(player.getUniqueId());
        this.statsManager.addDeathLocation(player.getUniqueId(), player.getLocation());
        if (player.getKiller() != null) {
            Player killer = player.getKiller();
            this.statsManager.incrementKills(killer.getUniqueId());
        }
        this.afkManager.updateActivity(player);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        this.statsManager.incrementBlocksMined(player.getUniqueId());
        this.afkManager.updateActivity(player);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().distanceSquared(event.getTo()) > 0.0) {
            Player player = event.getPlayer();
            this.statsManager.addDistanceTraveled(player.getUniqueId(), event.getFrom().distance(event.getTo()));
            this.afkManager.updateActivity(player);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        this.afkManager.updateActivity(event.getPlayer());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.afkManager.updateActivity(event.getPlayer());
    }
}

