/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.advanced_stats.managers;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AfkManager {
    private final JavaPlugin plugin;
    private final long afkTimeoutMillis;
    private final Map<UUID, Long> lastActivity = new ConcurrentHashMap<UUID, Long>();

    public AfkManager(JavaPlugin plugin, long afkTimeoutSeconds) {
        this.plugin = plugin;
        this.afkTimeoutMillis = afkTimeoutSeconds * 1000L;
        this.startAfkCheckTask();
    }

    public void updateActivity(Player player) {
        this.lastActivity.put(player.getUniqueId(), System.currentTimeMillis());
    }

    public void removePlayer(Player player) {
        this.lastActivity.remove(player.getUniqueId());
    }

    private void startAfkCheckTask() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
            long now = System.currentTimeMillis();
            for (Player player : Bukkit.getOnlinePlayers()) {
                long lastSeen;
                if (player.hasPermission("nsr-ai.afk.bypass") || now - (lastSeen = this.lastActivity.getOrDefault(player.getUniqueId(), now).longValue()) <= this.afkTimeoutMillis) continue;
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    String message = String.valueOf(ChatColor.YELLOW) + "[AFK] " + player.getName() + " has been inactive for over " + this.afkTimeoutMillis / 1000L / 60L + " minutes.";
                    Bukkit.broadcast((String)message, (String)"nsr-ai.admin.afk-notify");
                });
                this.updateActivity(player);
            }
        }, 600L, 600L);
    }
}

