/*
 * Decompiled with CFR 0.152.
 */
package com.nsr.ai.advanced_stats.managers;

import com.nsr.ai.advanced_stats.data.PlayerStats;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.plugin.java.JavaPlugin;

public class StatsManager {
    private final JavaPlugin plugin;
    private final Map<UUID, PlayerStats> statsMap = new ConcurrentHashMap<UUID, PlayerStats>();
    private final File statsFile;

    public StatsManager(JavaPlugin plugin) {
        this.plugin = plugin;
        File sharedDir = new File(plugin.getDataFolder().getParentFile(), "NSR-AI");
        if (!sharedDir.exists()) {
            sharedDir.mkdirs();
        }
        this.statsFile = new File(sharedDir, "advanced_stats.dat");
        this.loadStats();
    }

    public PlayerStats getPlayerStats(UUID uuid) {
        return this.statsMap.computeIfAbsent(uuid, k -> new PlayerStats());
    }

    public void incrementKills(UUID uuid) {
        this.getPlayerStats(uuid).setKills(this.getPlayerStats(uuid).getKills() + 1);
    }

    public void incrementDeaths(UUID uuid) {
        this.getPlayerStats(uuid).setDeaths(this.getPlayerStats(uuid).getDeaths() + 1);
    }

    public void incrementBlocksMined(UUID uuid) {
        this.getPlayerStats(uuid).setBlocksMined(this.getPlayerStats(uuid).getBlocksMined() + 1L);
    }

    public void addDistanceTraveled(UUID uuid, double distance) {
        this.getPlayerStats(uuid).setDistanceTraveled(this.getPlayerStats(uuid).getDistanceTraveled() + distance);
    }

    public void addDeathLocation(UUID uuid, Location location) {
        PlayerStats stats = this.getPlayerStats(uuid);
        String locString = String.format("world=%s,x=%.1f,y=%.1f,z=%.1f", location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
        stats.getDeathLocations().add(locString);
        if (stats.getDeathLocations().size() > 5) {
            stats.getDeathLocations().remove(0);
        }
    }

    public void addSessionInfo(UUID uuid, String sessionInfo) {
        PlayerStats stats = this.getPlayerStats(uuid);
        stats.getSessionHistory().add(sessionInfo);
        if (stats.getSessionHistory().size() > 10) {
            stats.getSessionHistory().remove(0);
        }
    }

    public List<Map.Entry<UUID, PlayerStats>> getTopPlayers(Comparator<Map.Entry<UUID, PlayerStats>> comparator, int count) {
        return this.statsMap.entrySet().stream().sorted(comparator.reversed()).limit(count).collect(Collectors.toList());
    }

    public void saveStats() {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.statsFile));){
            oos.writeObject(this.statsMap);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save advanced player stats: " + e.getMessage());
        }
    }

    public void loadStats() {
        if (this.statsFile.exists()) {
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.statsFile));){
                Object obj = ois.readObject();
                if (obj instanceof Map) {
                    this.statsMap.putAll((Map)obj);
                    this.plugin.getLogger().info("Advanced player stats loaded.");
                }
            }
            catch (IOException | ClassNotFoundException e) {
                this.plugin.getLogger().severe("Could not load advanced player stats: " + e.getMessage());
            }
        }
    }
}

