/*
 * Decompiled with CFR 0.152.
 */
package me.ImJoshh.elytra_physics.config;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.ImJoshh.elytra_physics.config.PlatformConfigValueProvider;
import me.ImJoshh.elytra_physics.config.field.ConfigField;
import me.ImJoshh.elytra_physics.config.field.ListConfigField;
import me.ImJoshh.elytra_physics.mixinFlagSystem.ElytraPhysicsMixinFlags;
import net.minecraft.class_3887;
import net.minecraft.class_979;
import org.slf4j.Logger;

public class ElytraPhysicsConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PlatformConfigValueProvider valueProvider;
    private Set<Class<class_3887<?, ?>>> elytraLayers;
    private boolean enabled;
    private boolean adaptiveGravity;
    private boolean preventSnapping;
    private float gravityMultiplier;
    private float leanMultiplier;
    private float spreadMultiplier;

    public ElytraPhysicsConfig(PlatformConfigValueProvider valueProvider) {
        this.valueProvider = valueProvider;
        this.cacheFields();
    }

    public void cacheFields() {
        ArrayList<String> injectLayersStrings = new ArrayList<String>((Collection)this.valueProvider.getField(Spec.LAYER_INJECTORS.KEY));
        injectLayersStrings.add(class_979.class.getName());
        this.elytraLayers = injectLayersStrings.stream().map(layerClassName -> {
            try {
                Class<?> clazz = Class.forName(layerClassName);
                LOGGER.info("Successfully added class '" + clazz.getName() + "' to layer inject list");
                return clazz;
            }
            catch (Exception e) {
                LOGGER.info("Class '" + layerClassName + "' not found");
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        this.enabled = (Boolean)this.valueProvider.getField(Spec.ENABLED.KEY);
        this.preventSnapping = (Boolean)this.valueProvider.getField(Spec.PREVENT_SNAPPING.KEY);
        this.adaptiveGravity = (Boolean)this.valueProvider.getField(Spec.ADAPTIVE_GRAVITY.KEY);
        this.gravityMultiplier = (float)((Double)this.valueProvider.getField(Spec.GRAVITY_MULTIPLIER.KEY)).doubleValue();
        this.leanMultiplier = (float)((Double)this.valueProvider.getField(Spec.ELYTRA_LEAN_MULTIPLIER.KEY)).doubleValue();
        this.spreadMultiplier = (float)((Double)this.valueProvider.getField(Spec.ELYTRA_SPREAD_MULTIPLIER.KEY)).doubleValue();
        ElytraPhysicsMixinFlags.serialise(this.preventSnapping);
    }

    public Set<Class<class_3887<?, ?>>> getElytraLayers() {
        return this.elytraLayers;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean adaptiveGravityEnabled() {
        return this.adaptiveGravity;
    }

    public float getGravityMultiplier() {
        return this.gravityMultiplier;
    }

    public float getLeanMultiplier() {
        return this.leanMultiplier;
    }

    public float getSpreadMultiplier() {
        return this.spreadMultiplier;
    }

    public static class Spec {
        public static ListConfigField<String> LAYER_INJECTORS = new ListConfigField<String>("inject_layers", String.class, () -> "");
        public static ConfigField<Boolean> ENABLED = new ConfigField<Boolean>("enabled", Boolean.class);
        public static ConfigField<Boolean> ADAPTIVE_GRAVITY = new ConfigField<Boolean>("adaptive_gravity", Boolean.class);
        public static ConfigField<Boolean> PREVENT_SNAPPING = new ConfigField<Boolean>("prevent_snapping", Boolean.class);
        public static ConfigField<Double> GRAVITY_MULTIPLIER = new ConfigField<Double>("gravity_multiplier", Double.class);
        public static ConfigField<Double> ELYTRA_LEAN_MULTIPLIER = new ConfigField<Double>("elytra_lean_multiplier", Double.class);
        public static ConfigField<Double> ELYTRA_SPREAD_MULTIPLIER = new ConfigField<Double>("elytra_spread_multiplier", Double.class);

        public static ConfigField<?>[] get() {
            return new ConfigField[]{LAYER_INJECTORS, ENABLED, ADAPTIVE_GRAVITY, PREVENT_SNAPPING, GRAVITY_MULTIPLIER, ELYTRA_LEAN_MULTIPLIER, ELYTRA_SPREAD_MULTIPLIER};
        }
    }
}

