/*
 * Decompiled with CFR 0.152.
 */
package me.ImJoshh.elytra_physics.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Consumer;
import me.ImJoshh.elytra_physics.ElytraPhysics;
import me.ImJoshh.elytra_physics.ElytraPhysicsClientMod;
import me.ImJoshh.elytra_physics.config.ConfigFile;
import me.ImJoshh.elytra_physics.config.DefaultConfig;
import me.ImJoshh.elytra_physics.config.PlatformConfigValueProvider;
import net.fabricmc.loader.api.FabricLoader;

public class FabricConfig {
    private static ConfigFile loadedConfig;
    private static ConfigFile defaultConfig;
    public static final PlatformConfigValueProvider VALUE_PROVIDER;

    public static void init() {
        Map<String, Object> defaultConfigJson = DefaultConfig.getDefaultConfigJSON(ElytraPhysicsClientMod.class);
        if (defaultConfigJson == null) {
            throw new RuntimeException("Default config file could not be found in mod Jar");
        }
        defaultConfig = ConfigFile.fromJSON(defaultConfigJson);
        FabricConfig.loadConfigFromDisk();
    }

    private static void loadConfigFromDisk() {
        assert (defaultConfig != null);
        Path configDir = FabricLoader.getInstance().getConfigDir();
        File configFile = configDir.resolve("elytra-physics-config.json").toFile();
        if (!configFile.exists()) {
            loadedConfig = defaultConfig.copy(configFile);
            FabricConfig.save(loadedConfig);
        } else {
            loadedConfig = ConfigFile.fromFile(configFile);
        }
    }

    public static <T> T getConfigValue(String key) {
        Object fromLoaded = loadedConfig.get(key);
        if (fromLoaded != null) {
            return fromLoaded;
        }
        Object fromDefault = defaultConfig.get(key);
        if (fromDefault != null) {
            loadedConfig.set(key, fromDefault);
            FabricConfig.save(loadedConfig);
            return fromDefault;
        }
        return null;
    }

    public static <T> T getDefaultValue(String key) {
        return defaultConfig.get(key);
    }

    public static void attemptSaveOperation(Consumer<ConfigFile> updateFields) {
        ConfigFile configCopy = loadedConfig.copy();
        updateFields.accept(configCopy);
        boolean success = FabricConfig.save(configCopy);
        if (success) {
            loadedConfig = configCopy;
            ElytraPhysics.getConfig().cacheFields();
        }
    }

    private static boolean save(ConfigFile file) {
        try {
            file.saveConfig();
            ElytraPhysicsClientMod.LOGGER.info("Successfully saved config to file " + loadedConfig.getFilePath());
            return true;
        }
        catch (IOException e) {
            ElytraPhysicsClientMod.LOGGER.error("Config file could not be saved");
            e.printStackTrace();
            return false;
        }
    }

    static {
        VALUE_PROVIDER = FabricConfig::getConfigValue;
    }
}

