/*
 * Decompiled with CFR 0.152.
 */
package me.ImJoshh.elytra_physics.config.ui;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.ImJoshh.elytra_physics.ElytraPhysicsClientMod;
import me.ImJoshh.elytra_physics.config.ElytraPhysicsConfig;
import me.ImJoshh.elytra_physics.config.FabricConfig;
import me.ImJoshh.elytra_physics.config.field.ConfigField;
import me.ImJoshh.elytra_physics.config.field.ListConfigField;
import me.ImJoshh.elytra_physics.config.ui.ConfigScreen;
import me.ImJoshh.elytra_physics.config.ui.widget.BooleanConfigValue;
import me.ImJoshh.elytra_physics.config.ui.widget.ConfigValue;
import me.ImJoshh.elytra_physics.config.ui.widget.DoubleConfigValue;
import me.ImJoshh.elytra_physics.config.ui.widget.StringListConfigValue;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.slf4j.Logger;

public class ElytraPhysicsConfigScreen
extends ConfigScreen {
    private static final Logger LOGGER = LogUtils.getLogger();

    public ElytraPhysicsConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"elytra_physics.configuration.title"));
    }

    @Override
    public ConfigValue<?, ?>[] getConfigEntries() {
        return (ConfigValue[])Arrays.stream(ElytraPhysicsConfig.Spec.get()).map(this::resolveConfigField).filter(Objects::nonNull).toArray(ConfigValue[]::new);
    }

    private <T> ConfigValue<?, ?> resolveConfigField(ConfigField<T> field) {
        Object configValue = FabricConfig.getConfigValue(field.KEY);
        if (configValue == null) {
            LOGGER.warn(String.format("Config field '%s' could not find value", field.KEY));
            return null;
        }
        if (field instanceof ListConfigField && field.getFieldType().equals(String.class)) {
            return new StringListConfigValue(field.KEY, (List)configValue, (List)FabricConfig.getDefaultValue(field.KEY), this.field_22787, this);
        }
        if (field.getFieldType().equals(Double.class)) {
            return new DoubleConfigValue(field.KEY, (Double)configValue, (Double)FabricConfig.getDefaultValue(field.KEY), this.field_22787);
        }
        if (field.getFieldType().equals(Boolean.class)) {
            return new BooleanConfigValue(field.KEY, (Boolean)configValue, (Boolean)FabricConfig.getDefaultValue(field.KEY), this.field_22787);
        }
        return null;
    }

    @Override
    public void onSave(ConfigValue<?, ?>[] entries) {
        ElytraPhysicsClientMod.LOGGER.info("attempting to save config changes...");
        FabricConfig.attemptSaveOperation(configFile -> {
            for (ConfigValue entry : entries) {
                configFile.set(entry.getKey(), entry.getValue());
            }
        });
    }
}

