/*
 * Decompiled with CFR 0.152.
 */
package me.ImJoshh.elytra_physics.config.ui.widget;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.ImJoshh.elytra_physics.ElytraPhysicsClientMod;
import me.ImJoshh.elytra_physics.config.ui.widget.ConfigFieldList;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;

public class ListEntryList<T>
extends class_4265<ConfigListEntry> {
    private final Function<T, ConfigListEntry> entryProvider;
    private final AddBtnListEntry addOption;

    public ListEntryList(class_310 minecraft, List<T> values, Class<T> clazz) {
        super(minecraft, 0, 0, 0, ConfigFieldList.ROW_HEIGHT + ConfigFieldList.ROW_PADDING * 2);
        this.entryProvider = this.determineEntryProvider(clazz);
        this.addEntries(values);
        this.addOption = new AddBtnListEntry(this::addNewEntry);
        this.method_25321((class_350.class_351)this.addOption);
    }

    public List<T> getValues() {
        return this.method_25396().stream().filter(entry -> entry instanceof HasValue).map(entry -> ((HasValue)((Object)entry)).getValue()).collect(Collectors.toList());
    }

    private Function<T, ConfigListEntry> determineEntryProvider(Class<T> clazz) {
        if (clazz.equals(String.class)) {
            return str -> new StringListEntry((String)str, x$0 -> this.method_25330((class_350.class_351)x$0));
        }
        ElytraPhysicsClientMod.LOGGER.warn(String.format("%s config list type is not currently supported", clazz.getName()));
        return null;
    }

    private void addEntries(List<T> values) {
        if (this.entryProvider == null) {
            return;
        }
        for (T value : values) {
            this.method_25321((class_350.class_351)this.entryProvider.apply(value));
        }
    }

    private void addNewEntry() {
        this.method_25330((class_350.class_351)this.addOption);
        this.method_25321((class_350.class_351)this.entryProvider.apply(null));
        this.method_25321((class_350.class_351)this.addOption);
    }

    public int method_25322() {
        return 300;
    }

    public class AddBtnListEntry
    extends ConfigListEntry {
        private final class_4185 addButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), button -> callback.run()).method_46437(ConfigFieldList.ROW_HEIGHT, ConfigFieldList.ROW_HEIGHT).method_46435(component -> class_2561.method_43471((String)"elytra_physics.narrator.config_list_add_entry")).method_46431();

        public AddBtnListEntry(Runnable callback) {
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean bl, float delta) {
            this.addButton.method_48229(this.method_73380() + ListEntryList.this.method_25322() / 2 - this.addButton.method_25368() / 2, this.method_73382() + ConfigFieldList.ROW_PADDING);
            this.addButton.method_25394(guiGraphics, mouseX, mouseY, delta);
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return List.of(this.addButton);
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return List.of(this.addButton);
        }
    }

    public static abstract class ConfigListEntry
    extends class_4265.class_4266<ConfigListEntry> {
    }

    public class StringListEntry
    extends ConfigListEntry
    implements HasValue<String> {
        private final class_342 valueEditBox;
        private final class_4185 removeButton;

        public StringListEntry(String value, Consumer<ConfigListEntry> removeMe) {
            int editBoxWidth = ListEntryList.this.method_25322() - ConfigFieldList.ROW_PADDING * 3 - ConfigFieldList.ROW_HEIGHT;
            this.valueEditBox = new class_342(((ListEntryList)ListEntryList.this).field_22740.field_1772, 0, 0, editBoxWidth, ConfigFieldList.ROW_HEIGHT, class_5244.field_39678);
            this.valueEditBox.method_1880(9999);
            this.valueEditBox.method_1852(value);
            this.removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"X"), button -> removeMe.accept(this)).method_46437(ConfigFieldList.ROW_HEIGHT, ConfigFieldList.ROW_HEIGHT).method_46435(component -> class_2561.method_43469((String)"elytra_physics.narrator.config_list_delete_entry", (Object[])new Object[]{class_2561.method_43470((String)this.valueEditBox.method_1882())})).method_46431();
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean bl, float delta) {
            int y = this.method_73382() + ConfigFieldList.ROW_PADDING;
            this.removeButton.method_48229(ListEntryList.this.method_65507() - ConfigFieldList.ROW_PADDING - this.removeButton.method_25368(), y);
            this.removeButton.method_25394(guiGraphics, mouseX, mouseY, delta);
            this.valueEditBox.method_48229(this.method_73380() + ConfigFieldList.ROW_PADDING, y);
            this.valueEditBox.method_25394(guiGraphics, mouseX, mouseY, delta);
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return List.of(this.valueEditBox, this.removeButton);
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return List.of(this.valueEditBox, this.removeButton);
        }

        @Override
        public String getValue() {
            return this.valueEditBox.method_1882();
        }
    }

    public static interface HasValue<T> {
        public T getValue();
    }
}

