/*
 * Decompiled with CFR 0.152.
 */
package me.ImJoshh.elytra_physics.mixinFlagSystem;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MixinFlagsManager {
    private static final Path FLAGS_CONFIG_FILE_DIR = Paths.get(System.getProperty("user.dir") + String.format("/config/%s_mixin-flags.txt", "elytra_physics"), new String[0]);
    private final Map<String, Boolean> defaults;

    public MixinFlagsManager(Map<String, Boolean> defaults) {
        this.defaults = defaults;
    }

    public Map<String, Boolean> loadMixinFlags() {
        try {
            List<String> rawConfig = Files.readAllLines(FLAGS_CONFIG_FILE_DIR);
            return this.parseRawFlags(rawConfig);
        }
        catch (IOException e) {
            LogUtils.getLogger().warn(String.format("Mixin flags for '%s' could not be loaded: %s", "elytra_physics", e.getMessage()));
            return this.defaults;
        }
    }

    public void serialiseFlags(Map<String, Boolean> flags) throws IOException {
        StringBuilder plaintextBuilder = new StringBuilder();
        for (Map.Entry<String, Boolean> flag : flags.entrySet()) {
            plaintextBuilder.append(flag.getKey()).append("=").append(flag.getValue()).append("\n");
        }
        Files.writeString(FLAGS_CONFIG_FILE_DIR, (CharSequence)plaintextBuilder.toString(), new OpenOption[0]);
    }

    private Map<String, Boolean> parseRawFlags(List<String> lines) {
        HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        for (String line : lines) {
            String[] split = line.split("=");
            String key = split[0].toLowerCase().trim();
            Boolean state = Boolean.parseBoolean(split[1]);
            flags.put(key, state);
        }
        return flags;
    }
}

