/*
 * Decompiled with CFR 0.152.
 */
package com.hlhtstudios.taczcustomdeath.network.event;

import com.hlhtstudios.taczcustomdeath.Taczcustomdeath;
import com.hlhtstudios.taczcustomdeath.network.message.ClientGunKillHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class ServerSendGunKill {
    public final ResourceLocation gunId;
    public final ResourceLocation displayId;
    public final UUID attackerId;
    public final UUID victimId;
    public final String attackerName;
    public final String victimName;
    public final String attackerTeam;
    public final String victimTeam;
    public final boolean isHeadShot;

    public ServerSendGunKill(ResourceLocation gunId, ResourceLocation displayId, UUID attackerId, UUID victimId, String attackerName, String victimName, String attackerTeam, String victimTeam, boolean isHeadShot) {
        this.gunId = gunId;
        this.displayId = displayId;
        this.attackerId = attackerId;
        this.victimId = victimId;
        this.attackerName = attackerName;
        this.victimName = victimName;
        this.attackerTeam = attackerTeam;
        this.victimTeam = victimTeam;
        this.isHeadShot = isHeadShot;
    }

    public static void encode(ServerSendGunKill pkt, FriendlyByteBuf buf) {
        Taczcustomdeath.LOGGER.info("Encoding packet: " + pkt.attackerId + ", " + pkt.attackerName);
        Taczcustomdeath.LOGGER.info("Att Team: " + pkt.attackerTeam + "Vic Team" + pkt.victimTeam);
        buf.m_130085_(pkt.gunId);
        buf.m_130085_(pkt.displayId);
        buf.m_130077_(pkt.attackerId);
        buf.m_130077_(pkt.victimId);
        buf.m_130070_(pkt.attackerName);
        buf.m_130070_(pkt.victimName);
        buf.m_130070_(pkt.attackerTeam);
        buf.m_130070_(pkt.victimTeam);
        buf.writeBoolean(pkt.isHeadShot);
    }

    public static ServerSendGunKill decode(FriendlyByteBuf buf) {
        Taczcustomdeath.LOGGER.info("Readable bytes: " + buf.readableBytes());
        return new ServerSendGunKill(buf.m_130281_(), buf.m_130281_(), buf.m_130259_(), buf.m_130259_(), buf.m_130136_(Short.MAX_VALUE), buf.m_130136_(Short.MAX_VALUE), buf.m_130136_(Short.MAX_VALUE), buf.m_130136_(Short.MAX_VALUE), buf.readBoolean());
    }

    public static void handle(ServerSendGunKill pkt, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        Taczcustomdeath.LOGGER.info("Someone has been killed Both");
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> ClientGunKillHandler.handleGunKill(pkt));
        }
        context.setPacketHandled(true);
    }
}

