/*
 * Decompiled with CFR 0.152.
 */
package com.hlhtstudios.taczcustomdeath.client;

import com.hlhtstudios.taczcustomdeath.Taczcustomdeath;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class KillHUD
implements IGuiOverlay {
    public static KillHUD INSTANCE = new KillHUD();
    private static final int MAX_MESSAGES = 7;
    private static final int ICON_SIZE = 24;
    private static final int ICON_SIZE2 = 8;
    private static final int SPACING_X = 8;
    private static final int SPACING_Y = 1;
    private static final int MARGIN_RIGHT = 20;
    private static final int MARGIN_BOTTOM = 70;
    private final Deque<KillMessage> messages = new LinkedList<KillMessage>();

    public void pushKill(UUID attacker, UUID victim, String attackerName, String victimName, String attackerTeam, String victimTeam, ResourceLocation weaponIcon, boolean isHeadShot) {
        PlayerTeam victimTeamT;
        PlayerTeam attackerTeamT;
        if (this == null) {
            Taczcustomdeath.LOGGER.error("KillHUD.INSTANCE is null!");
        }
        Taczcustomdeath.LOGGER.info("Try pushing kill");
        if (attacker == null || victim == null || weaponIcon == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            Taczcustomdeath.LOGGER.error("Minecraft level or player is null");
            return;
        }
        int attackerColor = 11746358;
        int victimColor = 11746358;
        Taczcustomdeath.LOGGER.info("{}{}", (Object)attacker.toString(), (Object)mc.f_91074_.m_20148_().toString());
        Taczcustomdeath.LOGGER.info(String.valueOf(Objects.equals(attacker.toString(), mc.f_91074_.m_20148_().toString())));
        if (!Objects.equals(attackerTeam, "") && mc.f_91074_.m_20031_((Team)(attackerTeamT = mc.f_91073_.m_6188_().m_83489_(attackerTeam)))) {
            attackerColor = 0x22FF00;
        }
        if (!Objects.equals(victimTeam, "") && mc.f_91074_.m_20031_((Team)(victimTeamT = mc.f_91073_.m_6188_().m_83489_(victimTeam)))) {
            victimColor = 0x22FF00;
        }
        if (Objects.equals(attacker.toString(), mc.f_91074_.m_20148_().toString())) {
            attackerColor = 0xFFBF00;
        }
        if (Objects.equals(victim.toString(), mc.f_91074_.m_20148_().toString())) {
            victimColor = 0xFFBF00;
        }
        this.messages.addLast(new KillMessage(attackerName, attackerColor, victimName, victimColor, weaponIcon));
        if (this.messages.size() > 7) {
            this.messages.removeFirst();
        }
    }

    public static void drawFlippedIcon(ResourceLocation texture, int x, int y, int width, int height, float alpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_5483_((double)x, (double)y, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    public static ResourceLocation get_flipped_texture(ResourceLocation textureLocation) {
        Resource resource = (Resource)Minecraft.m_91087_().m_91098_().m_213713_(textureLocation).orElseThrow();
        NativeImage image = null;
        try (InputStream is = resource.m_215507_();){
            image = NativeImage.m_85048_((NativeImage.Format)NativeImage.Format.RGBA, (InputStream)is);
        }
        catch (IOException e) {
            Taczcustomdeath.LOGGER.error("Failed to load and flip texture: {}", (Object)textureLocation, (Object)e);
        }
        if (image != null) {
            int width = image.m_84982_();
            int height = image.m_85084_();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width / 2; ++x) {
                    int left = image.m_84985_(x, y);
                    int right = image.m_84985_(width - 1 - x, y);
                    image.m_84988_(x, y, right);
                    image.m_84988_(width - 1 - x, y, left);
                }
            }
            DynamicTexture dynTex = new DynamicTexture(image);
            return Minecraft.m_91087_().m_91097_().m_118490_("flipped_texture", dynTex);
        }
        return textureLocation;
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        this.messages.removeIf(KillMessage::isExpired);
        int baseY = screenHeight - 70;
        int i = 0;
        Iterator<KillMessage> it = this.messages.descendingIterator();
        while (it.hasNext()) {
            float scale_ratio = 0.75f;
            KillMessage msg = it.next();
            int alphaInt = (int)(msg.getAlpha() * 255.0f);
            int attackerColorWithAlpha = alphaInt << 24 | msg.attackerColor & 0xFFFFFF;
            int victimColorWithAlpha = alphaInt << 24 | msg.victimColor & 0xFFFFFF;
            int attackerWidth = (int)((float)font.m_92895_(msg.attackerName) * scale_ratio);
            int victimWidth = (int)((float)font.m_92895_(msg.victimName) * scale_ratio);
            int totalWidth = (int)(16.0f * scale_ratio + 24.0f + (float)victimWidth + (float)attackerWidth);
            int xDelta = (int)((float)attackerWidth - (float)attackerWidth * scale_ratio);
            Objects.requireNonNull(font);
            Objects.requireNonNull(font);
            int yDelta = (int)((9.0f - 9.0f * scale_ratio) / 2.0f);
            int posX = (int)((float)(screenWidth - 20 - totalWidth) / scale_ratio);
            int posX2 = screenWidth - 20 - totalWidth;
            int posY = (int)((float)(baseY - i * 9) / scale_ratio + (float)yDelta);
            int posY2 = baseY - i * 9;
            PoseStack pose = guiGraphics.m_280168_();
            pose.m_85836_();
            pose.m_85841_(scale_ratio, scale_ratio, 1.0f);
            String string = msg.attackerName;
            Objects.requireNonNull(font);
            guiGraphics.m_280056_(font, string, posX, posY + (8 - 9) / 2, attackerColorWithAlpha, false);
            pose.m_85849_();
            int iconX = (int)((float)(posX2 + attackerWidth) + 8.0f * scale_ratio);
            KillHUD.drawFlippedIcon(msg.weaponIcon, iconX, posY2 - 1, 24, 8, msg.getAlpha());
            pose.m_85836_();
            pose.m_85841_(scale_ratio, scale_ratio, 1.0f);
            int victimX = (int)((float)(iconX + 24) / scale_ratio + 8.0f);
            String string2 = msg.victimName;
            Objects.requireNonNull(font);
            guiGraphics.m_280056_(font, string2, victimX, posY + (8 - 9) / 2, victimColorWithAlpha, false);
            pose.m_85849_();
            ++i;
        }
    }

    private static class KillMessage {
        public final String attackerName;
        public final int attackerColor;
        public final String victimName;
        public final int victimColor;
        public final ResourceLocation weaponIcon;
        public final long timestamp;

        public KillMessage(String attackerName, int attackerColor, String victimName, int victimColor, ResourceLocation weaponIcon) {
            this.attackerName = attackerName;
            this.attackerColor = attackerColor;
            this.victimName = victimName;
            this.victimColor = victimColor;
            this.weaponIcon = weaponIcon;
            this.timestamp = System.currentTimeMillis();
        }

        public float getAlpha() {
            long age = System.currentTimeMillis() - this.timestamp;
            if (age >= 6000L) {
                return 0.1f;
            }
            if (age >= 5100L) {
                return 1.0f - ((float)age - 5100.0f) / 1000.0f;
            }
            return 1.0f;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 6000L;
        }
    }
}

