/*
 * Decompiled with CFR 0.152.
 */
package jonyboylovespie.playtimeplugin.playtimePlugin;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public final class PlaytimePlugin
extends JavaPlugin
implements Listener {
    private Map<UUID, Long> joinTimes;
    private Map<UUID, Long> lastMoveTimes;
    private Set<UUID> afkPlayers;
    private FileConfiguration config;
    private String currentDate;
    private BukkitTask timeCheckTask;
    private long maxDailyPlaytimeMinutes;
    private boolean ignoreAfkPlayers;

    public void onEnable() {
        this.joinTimes = new HashMap<UUID, Long>();
        this.lastMoveTimes = new HashMap<UUID, Long>();
        this.afkPlayers = new HashSet<UUID>();
        this.currentDate = LocalDate.now().toString();
        this.saveDefaultConfig();
        this.config = this.getConfig();
        if (!this.config.contains("date")) {
            this.config.set("date", (Object)this.currentDate);
        }
        if (!this.config.contains("maxDailyPlaytimeMinutes")) {
            this.config.set("maxDailyPlaytimeMinutes", (Object)0);
        }
        if (!this.config.contains("ignoreAfkPlayers")) {
            this.config.set("ignoreAfkPlayers", (Object)false);
        }
        this.saveConfig();
        this.ignoreAfkPlayers = this.config.getBoolean("ignoreAfkPlayers", false);
        this.maxDailyPlaytimeMinutes = this.config.getLong("maxDailyPlaytimeMinutes");
        String storedDate = this.config.getString("date", this.currentDate);
        if (!storedDate.equals(this.currentDate)) {
            this.resetDailyPlaytime();
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.scheduleDailyReset();
        this.startTimeCheckTask();
        this.startAfkCheckTask();
    }

    public void onDisable() {
        if (this.timeCheckTask != null) {
            this.timeCheckTask.cancel();
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.savePlayerPlaytime(player);
        }
        this.saveConfig();
    }

    private void startTimeCheckTask() {
        this.timeCheckTask = Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.checkPlayerTimeLimits(player);
            }
        }, 1200L, 1200L);
    }

    private void checkPlayerTimeLimits(Player player) {
        UUID playerId = player.getUniqueId();
        this.savePlayerPlaytime(player);
        this.joinTimes.put(playerId, System.currentTimeMillis());
        long dailyPlaytimeMinutes = this.config.getLong("players." + String.valueOf(playerId) + ".daily", 0L) / 60000L;
        if (this.maxDailyPlaytimeMinutes > 0L && dailyPlaytimeMinutes >= this.maxDailyPlaytimeMinutes) {
            player.kickPlayer(String.valueOf(ChatColor.RED) + "You have reached your daily playtime limit of " + this.maxDailyPlaytimeMinutes + " minutes.");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.joinTimes.put(player.getUniqueId(), System.currentTimeMillis());
        this.lastMoveTimes.put(player.getUniqueId(), System.currentTimeMillis());
        this.afkPlayers.remove(player.getUniqueId());
        this.resetTabName(player);
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.checkPlayerTimeLimits(player), 20L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.savePlayerPlaytime(player);
        this.lastMoveTimes.remove(player.getUniqueId());
        this.afkPlayers.remove(player.getUniqueId());
        this.resetTabName(player);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getTo() == null) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (event.getFrom().getX() != event.getTo().getX() || event.getFrom().getY() != event.getTo().getY() || event.getFrom().getZ() != event.getTo().getZ()) {
            this.lastMoveTimes.put(playerId, System.currentTimeMillis());
            if (this.afkPlayers.contains(playerId)) {
                this.afkPlayers.remove(playerId);
                this.resetTabName(player);
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "You are no longer AFK.");
            }
        }
    }

    private void startAfkCheckTask() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            long now = System.currentTimeMillis();
            for (Player player : Bukkit.getOnlinePlayers()) {
                UUID playerId = player.getUniqueId();
                long lastMove = this.lastMoveTimes.getOrDefault(playerId, now);
                boolean isAfk = this.afkPlayers.contains(playerId);
                if (!isAfk && now - lastMove >= 60000L) {
                    this.afkPlayers.add(playerId);
                    this.setAfkTabName(player);
                    player.sendMessage(String.valueOf(ChatColor.GRAY) + "You are now AFK.");
                    continue;
                }
                if (!isAfk || now - lastMove >= 60000L) continue;
                this.afkPlayers.remove(playerId);
                this.resetTabName(player);
            }
        }, 20L, 20L);
    }

    private void setAfkTabName(Player player) {
        player.setPlayerListName(String.valueOf(ChatColor.GRAY) + player.getName());
    }

    private void resetTabName(Player player) {
        player.setPlayerListName(String.valueOf(ChatColor.RESET) + player.getName());
    }

    @EventHandler
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        this.joinTimes.put(playerId, System.currentTimeMillis());
        this.lastMoveTimes.put(playerId, System.currentTimeMillis());
        this.afkPlayers.remove(playerId);
        this.resetTabName(player);
    }

    @EventHandler
    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        this.savePlayerPlaytime(player);
        this.joinTimes.remove(playerId);
        this.lastMoveTimes.remove(playerId);
        this.afkPlayers.remove(playerId);
        this.resetTabName(player);
    }

    private void savePlayerPlaytime(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.joinTimes.containsKey(playerId)) {
            if (this.ignoreAfkPlayers && this.afkPlayers.contains(playerId)) {
                this.joinTimes.put(playerId, System.currentTimeMillis());
                return;
            }
            long sessionTime = System.currentTimeMillis() - this.joinTimes.get(playerId);
            this.joinTimes.remove(playerId);
            String dailyPath = "players." + String.valueOf(playerId) + ".daily";
            long dailyPlaytime = this.config.getLong(dailyPath, 0L) + sessionTime;
            this.config.set(dailyPath, (Object)dailyPlaytime);
            String totalPath = "players." + String.valueOf(playerId) + ".total";
            long totalPlaytime = this.config.getLong(totalPath, 0L) + sessionTime;
            this.config.set(totalPath, (Object)totalPlaytime);
            this.config.set("players." + String.valueOf(playerId) + ".name", (Object)player.getName());
        }
        this.saveConfig();
    }

    private void resetDailyPlaytime() {
        ConfigurationSection playersSection = this.config.getConfigurationSection("players");
        if (playersSection != null) {
            for (String key : playersSection.getKeys(false)) {
                this.config.set("players." + key + ".daily", (Object)0);
            }
        }
        this.config.set("date", (Object)this.currentDate);
        this.saveConfig();
        this.getLogger().info("Daily playtime reset performed.");
    }

    private void scheduleDailyReset() {
        long ticksUntilMidnight = this.getTicksUntilMidnight();
        this.getLogger().info("Scheduling daily reset in " + ticksUntilMidnight + " ticks.");
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            this.resetDailyPlaytime();
            this.currentDate = LocalDate.now().toString();
            this.scheduleDailyReset();
        }, ticksUntilMidnight);
    }

    private long getTicksUntilMidnight() {
        ZonedDateTime now = ZonedDateTime.now();
        ZonedDateTime nextMidnight = now.toLocalDate().plusDays(1L).atStartOfDay(now.getZone());
        long millisecondsUntilMidnight = nextMidnight.toInstant().toEpochMilli() - now.toInstant().toEpochMilli();
        return Math.max(1L, millisecondsUntilMidnight / 50L);
    }

    private String formatPlaytime(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        return String.format("%02d hours, %02d minutes, %02d seconds", hours, minutes, seconds %= 60L);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (label.equalsIgnoreCase("playtime") || label.equalsIgnoreCase("pt")) {
            if (args.length == 0) {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
                    return true;
                }
                Player player = (Player)sender;
                UUID playerId = player.getUniqueId();
                this.savePlayerPlaytime(player);
                this.joinTimes.put(playerId, System.currentTimeMillis());
                long dailyPlaytime = this.config.getLong("players." + String.valueOf(playerId) + ".daily", 0L);
                long totalPlaytime = this.config.getLong("players." + String.valueOf(playerId) + ".total", 0L);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your playtime:");
                this.showData((CommandSender)player, dailyPlaytime, totalPlaytime);
                return true;
            }
            if (args.length == 1) {
                if (!sender.hasPermission("playtime.others")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to check others' playtime.");
                    return true;
                }
                String targetName = args[0];
                UUID targetId = null;
                ConfigurationSection playersSection = this.config.getConfigurationSection("players");
                if (playersSection != null) {
                    for (String key : playersSection.getKeys(false)) {
                        String name = this.config.getString("players." + key + ".name");
                        if (name == null || !name.equalsIgnoreCase(targetName)) continue;
                        targetId = UUID.fromString(key);
                        break;
                    }
                }
                if (targetId == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                Player targetPlayer = Bukkit.getPlayer(targetId);
                if (targetPlayer != null && targetPlayer.isOnline()) {
                    this.savePlayerPlaytime(targetPlayer);
                    this.joinTimes.put(targetId, System.currentTimeMillis());
                }
                long dailyPlaytime = this.config.getLong("players." + String.valueOf(targetId) + ".daily", 0L);
                long totalPlaytime = this.config.getLong("players." + String.valueOf(targetId) + ".total", 0L);
                String name = this.config.getString("players." + String.valueOf(targetId) + ".name");
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + name + "'s playtime:");
                this.showData(sender, dailyPlaytime, totalPlaytime);
                return true;
            }
        }
        if ((label.equalsIgnoreCase("playLimit") || label.equalsIgnoreCase("pl")) && args.length == 2 && args[0].equalsIgnoreCase("set") && sender.hasPermission("playtime.admin")) {
            try {
                int minutes = Integer.parseInt(args[1]);
                if (minutes < 0) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Time limit cannot be negative.");
                    return true;
                }
                this.config.set("maxDailyPlaytimeMinutes", (Object)minutes);
                this.maxDailyPlaytimeMinutes = minutes;
                this.saveConfig();
                if (minutes == 0) {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Daily playtime limit disabled.");
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Daily playtime limit set to " + minutes + " minutes.");
                }
                return true;
            }
            catch (NumberFormatException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Please enter a valid number of minutes.");
                return true;
            }
        }
        return false;
    }

    private void showData(CommandSender sender, long dailyPlaytime, long totalPlaytime) {
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Today: " + String.valueOf(ChatColor.WHITE) + this.formatPlaytime(dailyPlaytime));
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Total: " + String.valueOf(ChatColor.WHITE) + this.formatPlaytime(totalPlaytime));
    }
}

