/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.client;

import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class ComponentUtils {
    public static final ButtonComponent.Renderer BUTTON_RENDERER = ComponentUtils.createThemedButtonRenderer(AlloyForgery.CONFIG::darkModeTheme);

    public static ResourceLocation themedTextureID(String suffix) {
        return ComponentUtils.themedTextureID(suffix, AlloyForgery.CONFIG::darkModeTheme);
    }

    public static ResourceLocation themedTextureID(String suffix, Supplier<Boolean> isDarkMode) {
        return AlloyForgery.id("textures/gui/theme/" + (isDarkMode.get() != false ? "dark" : "light") + "/" + suffix);
    }

    public static ResourceLocation textureID(String suffix) {
        return AlloyForgery.id("textures/gui/" + suffix);
    }

    public static <T> T getThemedValue(T light, T dark) {
        return AlloyForgery.CONFIG.darkModeTheme() ? dark : light;
    }

    public static ButtonComponent.Renderer createThemedButtonRenderer(Supplier<Boolean> isDarkMode) {
        return (context, button, delta) -> NinePatchTexture.draw((ResourceLocation)ComponentUtils.getBtnTexture(button, isDarkMode), (OwoUIDrawContext)context, (int)button.getX(), (int)button.getY(), (int)button.width(), (int)button.height());
    }

    private static ResourceLocation getBtnTexture(ButtonComponent btn, Supplier<Boolean> isDarkMode) {
        String btnType = btn.active() ? (btn.isHovered() ? "hovered" : "active") : "disabled";
        String themeType = isDarkMode.get() != false ? "dark" : "light";
        return AlloyForgery.id("theme/" + themeType + "/button/" + btnType);
    }

    public static <T> Component makeInputSlots(List<T> entries, int paddingInset, Supplier<Boolean> isDarkMode, Function<T, Component> slotBuilder, Predicate<T> isSlotDisabled) {
        return ((FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).configure(layout -> {
            boolean onlySingleRow;
            List<ParentComponent> inputSlots = entries.stream().map(arg_0 -> ComponentUtils.lambda$makeInputSlots$2(slotBuilder, paddingInset, (Supplier)isDarkMode, isSlotDisabled, arg_0)).toList();
            int middleIndex = (int)Math.floor((float)inputSlots.size() / 2.0f);
            boolean bl = onlySingleRow = inputSlots.size() <= 2;
            if (onlySingleRow) {
                middleIndex = inputSlots.size();
            }
            List<ParentComponent> topSlots = inputSlots.subList(0, middleIndex);
            layout.child((Component)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).children(topSlots));
            if (!onlySingleRow) {
                List<ParentComponent> bottomSlots = inputSlots.subList(middleIndex, inputSlots.size());
                layout.child((Component)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).children(bottomSlots));
            }
            layout.surface((context, component) -> context.drawRectOutline(component.x(), component.y(), component.width(), component.height(), ComponentUtils.getThemedValue(-13158601, -16053493).intValue()));
        })).padding(Insets.of((int)1)).horizontalAlignment(HorizontalAlignment.CENTER);
    }

    private static /* synthetic */ ParentComponent lambda$makeInputSlots$2(Function slotBuilder, int paddingInset, Supplier isDarkMode, Predicate isSlotDisabled, Object t) {
        return Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)slotBuilder.apply(t)).padding(Insets.of((int)paddingInset)).surface((arg_0, arg_1) -> ComponentUtils.lambda$makeInputSlots$1((Supplier)isDarkMode, isSlotDisabled, t, arg_0, arg_1));
    }

    private static /* synthetic */ void lambda$makeInputSlots$1(Supplier isDarkMode, Predicate isSlotDisabled, Object t, OwoUIDrawContext context, ParentComponent component) {
        ResourceLocation slotTexture = ComponentUtils.themedTextureID("input_slot_background.png", isDarkMode);
        context.blit(RenderType::guiTextured, slotTexture, component.x(), component.y(), isSlotDisabled.test(t) ? 18.0f : 0.0f, 0.0f, 18, 18, 36, 18);
    }
}

