/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.utils;

import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.data.providers.ResourceConditionHolder;
import io.wispforest.alloyforgery.utils.FluidStorage;
import io.wispforest.alloyforgery.utils.data.EndecDataLoader;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface GeneralPlatformUtils {
    public static final GeneralPlatformUtils INSTANCE = GeneralPlatformUtils.load(GeneralPlatformUtils.class);

    public <T extends AbstractContainerMenu, D> MenuType<T> createScreenHandlerType(ExtendedFactory<T, D> var1, StreamCodec<? super RegistryFriendlyByteBuf, D> var2);

    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(Factory<T> var1);

    public void addToBlockEntity(BlockEntityType<ForgeControllerBlockEntity> var1, Block ... var2);

    public boolean interactWithFluidStorage(ForgeControllerBlockEntity var1, Player var2, InteractionHand var3);

    public FluidStorage createStorage(ForgeControllerBlockEntity var1);

    public <I extends RecipeInput, T extends Recipe<I>> Stream<RecipeHolder<T>> getAllMatches(RecipeManager var1, RecipeType<T> var2, I var3, Level var4);

    public <I extends RecipeInput, T extends Recipe<I>> Collection<RecipeHolder<T>> getAllOfType(RecipeManager var1, RecipeType<T> var2);

    public Ingredient createStackIngredient(ItemStack var1);

    public void registerLoader(ResourceLocation var1, PackType var2, EndecDataLoader<?> var3, boolean var4);

    public ResourceConditionHolder createConditionsHolder();

    default public OptionalInt openHandledScreen(Player player, ForgeControllerBlockEntity blockEntity, @Nullable MenuProvider factory) {
        return player.openMenu(factory);
    }

    private static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        AlloyForgery.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    @FunctionalInterface
    public static interface Factory<T extends BlockEntity> {
        public T create(BlockPos var1, BlockState var2);
    }

    public static interface ExtendedFactory<T extends AbstractContainerMenu, D> {
        public T create(int var1, Inventory var2, D var3);
    }
}

