/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import io.wispforest.alloyforgery.mixin.PreparedRecipesAccessor;
import io.wispforest.alloyforgery.mixin.ServerRecipeManagerAccessor;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public final class RecipeInjector {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Event<AddRecipes> ADD_RECIPES = EventFactory.createArrayBacked(AddRecipes.class, addRecipes -> instance -> {
        for (AddRecipes addRecipe : addRecipes) {
            addRecipe.addRecipes(instance);
        }
    });
    private final RecipeManager manager;
    private final Level world;
    private final Multimap<RecipeType<?>, RecipeHolder<?>> recipes = HashMultimap.create();
    private final Map<ResourceLocation, RecipeHolder<?>> recipesById = new HashMap();

    public RecipeInjector(RecipeManager manager, Level world) {
        this.manager = manager;
        this.world = world;
    }

    public <R extends Recipe<T>, T extends RecipeInput> void addRecipe(ResourceLocation id, R recipe) {
        if (BuiltInRegistries.RECIPE_TYPE.getKey((Object)recipe.getType()) == null) {
            throw new IllegalStateException("Unable to add Recipe for a RecipeType not registered!");
        }
        RecipeType type = recipe.getType();
        boolean bl = this.getAllOfType(type).stream().anyMatch(recipeEntry -> id.equals((Object)recipeEntry.id()));
        if (bl) {
            LOGGER.error("[RecipeInjector]: Unable to add a given recipe due to being the same Identifier with the given Type. [ID: {}]", (Object)id);
            return;
        }
        RecipeHolder recipeEntry2 = new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)id), recipe);
        this.recipes.put((Object)recipe.getType(), (Object)recipeEntry2);
        this.recipesById.put(id, recipeEntry2);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Stream<RecipeHolder<T>> getAllMatches(RecipeType<T> type, I input, Level world) {
        return GeneralPlatformUtils.INSTANCE.getAllMatches(this.manager, type, input, world);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Collection<RecipeHolder<T>> getAllOfType(RecipeType<T> type) {
        return GeneralPlatformUtils.INSTANCE.getAllOfType(this.manager, type);
    }

    public RecipeManager manager() {
        return this.manager;
    }

    public HolderLookup.Provider lookup() {
        return ((ServerRecipeManagerAccessor)this.manager).af$getRegistryLookup();
    }

    public List<ItemStack> getStacks(Ingredient ingredient) {
        ContextMap ctx = SlotDisplayContext.fromLevel((Level)this.world);
        return ingredient.display().resolveForStacks(ctx);
    }

    public static void injectRecipes(MinecraftServer server) {
        RecipeManager manager = server.getRecipeManager();
        RecipeInjector injector = new RecipeInjector(server.getRecipeManager(), (Level)server.getLevel(Level.OVERWORLD));
        ((AddRecipes)ADD_RECIPES.invoker()).addRecipes(injector);
        PreparedRecipesAccessor preparedRecipesAccessor = (PreparedRecipesAccessor)((ServerRecipeManagerAccessor)manager).af$preparedRecipes();
        injector.recipes.putAll(preparedRecipesAccessor.af$getRecipes());
        injector.recipesById.putAll(preparedRecipesAccessor.af$getRecipesById());
        preparedRecipesAccessor.af$setRecipes((Multimap<RecipeType<?>, RecipeHolder<?>>)ImmutableMultimap.copyOf(injector.recipes));
        preparedRecipesAccessor.af$setRecipesById((Map<ResourceLocation, RecipeHolder<?>>)ImmutableMap.copyOf(injector.recipesById));
        injector.recipes.clear();
        injector.recipesById.clear();
    }

    public static interface AddRecipes {
        public void addRecipes(RecipeInjector var1);
    }
}

