/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.block;

import com.google.common.collect.ImmutableList;
import io.wispforest.alloyforgery.AlloyForgeScreenHandler;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.block.ForgeControllerBlock;
import io.wispforest.alloyforgery.block.ItemStackComparisonUtil;
import io.wispforest.alloyforgery.client.BlockEntityLocation;
import io.wispforest.alloyforgery.forges.ForgeDefinition;
import io.wispforest.alloyforgery.forges.ForgeFuelDataLoader;
import io.wispforest.alloyforgery.forges.ForgeRegistry;
import io.wispforest.alloyforgery.forges.ForgeTier;
import io.wispforest.alloyforgery.forges.ForgeTierDataLoader;
import io.wispforest.alloyforgery.mixin.HopperBlockEntityAccessor;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipeInput;
import io.wispforest.alloyforgery.utils.ExtObservable;
import io.wispforest.alloyforgery.utils.FluidStorage;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.owo.ops.ItemOps;
import io.wispforest.owo.util.ImplementedInventory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class ForgeControllerBlockEntity
extends class_2586
implements ImplementedInventory,
class_1278,
class_3908 {
    private static final int[] DOWN_SLOTS = new int[]{10, 11};
    private static final Integer[] RIGHT_SLOTS = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final int[] LEFT_SLOTS = new int[]{11};
    public static final int INVENTORY_SIZE = 12;
    public static class_2591<ForgeControllerBlockEntity> FORGE_CONTROLLER_BLOCK_ENTITY;
    private final class_2371<class_1799> items = class_2371.method_10213((int)12, (Object)class_1799.field_8037);
    public final ExtObservable<Set<Integer>> disabledSlots = ExtObservable.of(new HashSet());
    private final class_2371<class_1799> previousItems = class_2371.method_10211();
    private boolean checkForRecipes = true;
    private Optional<class_8786<AlloyForgeRecipe>> recipeCache = Optional.empty();
    public final ExtObservable<Integer> requiredTierToCraft = ExtObservable.of(-1);
    private final FluidStorage fluidHolder = GeneralPlatformUtils.INSTANCE.createStorage(this);
    private final class_2960 forgeDefinitionId;
    private final ImmutableList<class_2338> multiblockPositions;
    private final class_2350 facing;
    private float fuel;
    private int currentSmeltTime;
    public final ExtObservable<Integer> smeltProgress = ExtObservable.of(0);
    public final ExtObservable<Integer> fuelProgress = ExtObservable.of(0);
    public final ExtObservable<Integer> lavaProgress = ExtObservable.of(0);

    public ForgeControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(FORGE_CONTROLLER_BLOCK_ENTITY, pos, state);
        this.forgeDefinitionId = ((ForgeControllerBlock)state.method_26204()).forgeDefinitionId;
        this.facing = (class_2350)state.method_11654(ForgeControllerBlock.FACING);
        this.multiblockPositions = ForgeControllerBlockEntity.generateMultiblockPositions(pos.method_10062(), (class_2350)state.method_11654(ForgeControllerBlock.FACING));
    }

    public ForgeTier forgeTier() {
        if (this.field_11863 == null) {
            return ForgeTier.DEFAULT;
        }
        ForgeTier tier = ForgeTierDataLoader.getForgeRegistry(this.field_11863.method_8608()).getBoundForgeTier(this.forgeDefinitionId);
        if (tier == null) {
            return ForgeTier.DEFAULT;
        }
        return tier;
    }

    public BlockEntityLocation getExtraScreenData(class_3222 player) {
        return BlockEntityLocation.of(this);
    }

    protected void method_11014(class_11368 view) {
        class_1262.method_5429((class_11368)view, this.items);
        this.currentSmeltTime = view.method_71424("CurrentSmeltTime", 0);
        this.fuel = view.method_71424("Fuel", 0);
        class_11368 fluidData = view.method_71434("FuelFluidInput");
        this.fluidHolder.readData(fluidData);
    }

    protected void method_11007(class_11372 view) {
        class_1262.method_5426((class_11372)view, this.items);
        view.method_71465("Fuel", Math.round(this.fuel));
        view.method_71465("CurrentSmeltTime", this.currentSmeltTime);
        class_11372 fluidNbt = view.method_71461("FuelFluidInput");
        this.fluidHolder.writeData(fluidNbt);
    }

    public <F extends FluidStorage> F getFluidHolder() {
        return (F)this.fluidHolder;
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public class_1799 getFuelStack() {
        return this.method_5438(11);
    }

    public boolean canAddFuel(int fuel) {
        return this.fuel + (float)fuel <= (float)this.forgeTier().fuelCapacity();
    }

    public void addFuel(int fuel) {
        this.fuel += (float)fuel;
    }

    public int getSmeltProgress() {
        return (Integer)this.smeltProgress.get();
    }

    public int getCurrentSmeltTime() {
        return this.currentSmeltTime;
    }

    public ForgeDefinition getForgeDefinition() {
        return ForgeRegistry.getForgeDefinition(this.forgeDefinitionId).orElseThrow(() -> new IllegalArgumentException("Unable to locate the given definition as its not registered! [Id: " + String.valueOf(this.forgeDefinitionId) + "]"));
    }

    public void disableSlot(int index) {
        ((Set)this.disabledSlots.get()).add(index);
        this.disabledSlots.markDirty();
    }

    public void enableSlot(int index) {
        ((Set)this.disabledSlots.get()).remove(index);
        this.disabledSlots.markDirty();
    }

    public int getCompartorOutput() {
        return this.getCurrentSmeltTime() != 0 ? Math.max(1, Math.round((float)this.getSmeltProgress() * 0.46875f)) : 0;
    }

    public void method_5431() {
        if (ItemStackComparisonUtil.itemsChanged(this.items, this.previousItems)) {
            this.previousItems.clear();
            this.previousItems.addAll(this.items.stream().map(class_1799::method_7972).toList());
            this.checkForRecipes = true;
        }
        super.method_5431();
    }

    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        this.method_5431();
    }

    public void tick() {
        Object fuelStack;
        ForgeFuelDataLoader.ForgeFuelDefinition fuelDefinition;
        this.smeltProgress.set(Math.round((float)this.currentSmeltTime / (float)this.forgeTier().maxSmeltTime() * 19.0f));
        this.fuelProgress.set(Math.round(this.fuel / (float)this.forgeTier().fuelCapacity() * 48.0f));
        this.lavaProgress.set(Math.round(this.fluidHolder.fullnessAmount() * 50.0f));
        this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
        if (!this.verifyMultiblock()) {
            this.currentSmeltTime = 0;
            class_2680 currentState = this.field_11863.method_8320(this.field_11867);
            if (((Boolean)currentState.method_11654((class_2769)ForgeControllerBlock.LIT)).booleanValue()) {
                this.field_11863.method_8501(this.field_11867, (class_2680)currentState.method_11657((class_2769)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(false)));
            }
            return;
        }
        if (!this.getFuelStack().method_7960() && (fuelDefinition = ForgeFuelDataLoader.getFuelForItem((fuelStack = this.getFuelStack()).method_7909())) != ForgeFuelDataLoader.ForgeFuelDefinition.EMPTY && this.canAddFuel(fuelDefinition.fuel())) {
            this.getFuelStack().method_7934(1);
            this.attemptInsertOnIndex(11, fuelDefinition.hasReturnType() ? new class_1799((class_1935)fuelDefinition.returnType()) : class_1799.field_8037);
            this.fuel += (float)fuelDefinition.fuel();
        }
        for (Integer i : (Set)this.disabledSlots.get()) {
            class_1799 stack = this.method_5438(i);
            if (!stack.method_7960()) {
                this.insertIntoHopperOrScatterAtFront(stack);
            }
            this.method_5447(i, class_1799.field_8037);
        }
        float emptyFuelSpace = (float)this.forgeTier().fuelCapacity() - this.fuel;
        long fluidAmount = this.fluidHolder.getFluidAmountInDroplets();
        if (fluidAmount >= 81L && emptyFuelSpace > 0.0f) {
            float fuelInsertAmount = Math.min((float)fluidAmount / 81.0f, emptyFuelSpace / 24.0f);
            this.fuel += fuelInsertAmount * 24.0f;
            this.fluidHolder.setFluidAmountInDroplets((long)((float)fluidAmount - fuelInsertAmount * 81.0f));
        }
        class_2680 currentBlockState = this.field_11863.method_8320(this.field_11867);
        if (this.fuel > 100.0f && !((Boolean)currentBlockState.method_11654((class_2769)ForgeControllerBlock.LIT)).booleanValue()) {
            this.field_11863.method_8501(this.field_11867, (class_2680)currentBlockState.method_11657((class_2769)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(true)));
        } else if (this.fuel < 100.0f && ((Boolean)currentBlockState.method_11654((class_2769)ForgeControllerBlock.LIT)).booleanValue()) {
            this.field_11863.method_8501(this.field_11867, (class_2680)currentBlockState.method_11657((class_2769)ForgeControllerBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
        if (this.method_5442()) {
            this.currentSmeltTime = 0;
            return;
        }
        if (this.fuel < 5.0f || !this.checkForRecipes) {
            this.currentSmeltTime = 0;
            return;
        }
        AlloyForgeRecipeInput recipeInput = new AlloyForgeRecipeInput((class_1263)this);
        if (this.recipeCache.isEmpty() || !((AlloyForgeRecipe)this.recipeCache.get().comp_1933()).matches(recipeInput, this.field_11863)) {
            this.recipeCache = this.field_11863.method_8503().method_3772().method_8132((class_3956)AlloyForgeRecipe.Type.INSTANCE, (class_9695)recipeInput, this.field_11863);
        }
        if (this.recipeCache.isEmpty() && (Integer)this.requiredTierToCraft.get() != -1) {
            this.requiredTierToCraft.set(-1);
        }
        if (this.recipeCache.isEmpty() || !this.canSmelt((AlloyForgeRecipe)this.recipeCache.get().comp_1933())) {
            this.checkForRecipes = false;
            this.currentSmeltTime = 0;
            return;
        }
        AlloyForgeRecipe recipe = (AlloyForgeRecipe)this.recipeCache.get().comp_1933();
        if (this.currentSmeltTime < this.forgeTier().maxSmeltTime()) {
            float fuelRequirement = (float)recipe.getFuelPerTick() * this.forgeTier().fuelConsumptionMultiplier();
            if (this.fuel - fuelRequirement < 0.0f) {
                this.currentSmeltTime = 0;
                return;
            }
            ++this.currentSmeltTime;
            this.fuel -= fuelRequirement;
            if (this.field_11863.field_9229.method_43058() > 0.75) {
                AlloyForgery.FORGE_PARTICLES.spawn(this.field_11863, class_243.method_24954((class_2382)this.field_11867), (Object)this.facing);
            }
        } else {
            class_2371<class_1799> remainderList = AlloyForgeRecipe.gatherRemainders(this.recipeCache.get(), recipeInput);
            if (remainderList != null) {
                this.handleForgingRemainders(remainderList);
            }
            class_1799 outputStack = this.method_5438(10);
            class_1799 recipeOutput = recipe.craft(recipeInput, (class_7225.class_7874)this.field_11863.method_30349());
            recipe.consumeIngredients(recipeInput);
            if (outputStack.method_7960()) {
                this.method_5447(10, recipeOutput);
            } else {
                outputStack.method_7933(recipeOutput.method_7947());
            }
            this.currentSmeltTime = 0;
        }
    }

    private boolean canSmelt(AlloyForgeRecipe recipe) {
        class_1799 outputStack = this.method_5438(10);
        class_1799 recipeOutput = recipe.getResult(this.forgeTier().value());
        if (recipe.getMinForgeTier() > this.forgeTier().value()) {
            this.requiredTierToCraft.set(recipe.getMinForgeTier());
            return false;
        }
        if ((Integer)this.requiredTierToCraft.get() != -1) {
            this.requiredTierToCraft.set(-1);
        }
        return outputStack.method_7960() || ItemOps.canStack((class_1799)outputStack, (class_1799)recipeOutput);
    }

    private void handleForgingRemainders(class_2371<class_1799> remainderList) {
        for (int i = 0; i < remainderList.size(); ++i) {
            this.attemptInsertOnIndex(i, (class_1799)remainderList.get(i));
        }
    }

    public void attemptInsertOnIndex(int i, class_1799 itemstack) {
        if (itemstack.method_7960()) {
            return;
        }
        class_1799 slotStack = this.method_5438(i);
        if (slotStack.method_7960()) {
            this.method_5447(i, itemstack);
        } else if (class_1799.method_7984((class_1799)slotStack, (class_1799)itemstack) && class_1799.method_31577((class_1799)slotStack, (class_1799)itemstack)) {
            itemstack.method_7933(slotStack.method_7947());
            if (itemstack.method_7947() > itemstack.method_7914()) {
                int excess = itemstack.method_7947() - itemstack.method_7914();
                itemstack.method_7934(excess);
                class_1799 insertStack = itemstack.method_7972();
                insertStack.method_7939(excess);
                this.insertIntoHopperOrScatterAtFront(insertStack);
            }
            this.method_5447(i, itemstack);
        } else {
            this.insertIntoHopperOrScatterAtFront(itemstack);
        }
    }

    private void insertIntoHopperOrScatterAtFront(class_1799 stack) {
        if (!this.attemptToInsertIntoHopper(stack)) {
            class_2338 frontForgePos = this.field_11867.method_10093((class_2350)this.method_11010().method_11654(ForgeControllerBlock.FACING));
            this.field_11863.method_43128(null, (double)frontForgePos.method_10263(), (double)frontForgePos.method_10264(), (double)frontForgePos.method_10260(), class_3417.field_15197, class_3419.field_15245, 1.0f, 0.2f);
            class_1264.method_5449((class_1937)this.field_11863, (double)frontForgePos.method_10263(), (double)frontForgePos.method_10264(), (double)frontForgePos.method_10260(), (class_1799)stack);
        }
    }

    private boolean attemptToInsertIntoHopper(class_1799 remainderStack) {
        if (remainderStack.method_7960()) {
            return true;
        }
        class_2614 blockEntity = null;
        for (int y = 1; y <= 2; ++y) {
            class_2614 hopperBlockEntity;
            class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10087(y));
            if (!(class_25862 instanceof class_2614)) continue;
            blockEntity = hopperBlockEntity = (class_2614)class_25862;
            break;
        }
        if (blockEntity != null) {
            boolean isHopperEmpty = blockEntity.method_5442();
            for (int slotIndex = 0; slotIndex < blockEntity.method_5439() && !remainderStack.method_7960(); ++slotIndex) {
                if (!blockEntity.method_5438(slotIndex).method_7960()) {
                    class_1799 itemStack = blockEntity.method_5438(slotIndex);
                    if (itemStack.method_7960()) {
                        blockEntity.method_5447(slotIndex, remainderStack);
                        remainderStack = class_1799.field_8037;
                        continue;
                    }
                    if (!ItemOps.canStack((class_1799)itemStack, (class_1799)remainderStack)) continue;
                    int availableSpace = itemStack.method_7914() - itemStack.method_7947();
                    int j = Math.min(itemStack.method_7947(), availableSpace);
                    remainderStack.method_7934(j);
                    itemStack.method_7933(j);
                    continue;
                }
                blockEntity.method_5447(slotIndex, remainderStack);
                break;
            }
            if (isHopperEmpty && !((HopperBlockEntityAccessor)blockEntity).alloyForge$isDisabled()) {
                ((HopperBlockEntityAccessor)blockEntity).alloyForge$setTransferCooldown(8);
            }
            blockEntity.method_5431();
            return true;
        }
        return false;
    }

    public boolean verifyMultiblock() {
        class_2680 belowController = this.field_11863.method_8320((class_2338)this.multiblockPositions.get(0));
        ForgeDefinition forgeDefinition = this.getForgeDefinition();
        if (!belowController.method_27852(class_2246.field_10312) && !forgeDefinition.isBlockValid(belowController.method_26204())) {
            return false;
        }
        for (int i = 1; i < this.multiblockPositions.size(); ++i) {
            if (forgeDefinition.isBlockValid(this.field_11863.method_8320((class_2338)this.multiblockPositions.get(i)).method_26204())) continue;
            return false;
        }
        return true;
    }

    private static ImmutableList<class_2338> generateMultiblockPositions(class_2338 controllerPos, class_2350 controllerFacing) {
        ArrayList<class_2338> posses = new ArrayList<class_2338>();
        class_2338 center = controllerPos.method_10093(controllerFacing.method_10153());
        for (class_2338 pos : class_2338.method_10097((class_2338)center.method_10069(1, -1, 1), (class_2338)center.method_10069(-1, -1, -1))) {
            posses.add(pos.method_10062());
        }
        posses.remove(controllerPos.method_10074());
        posses.add(0, controllerPos.method_10074());
        for (int i = 0; i < 2; ++i) {
            class_2338 newCenter = center.method_10069(0, i, 0);
            posses.add(newCenter.method_10078());
            posses.add(newCenter.method_10067());
            posses.add(newCenter.method_10095());
            posses.add(newCenter.method_10072());
        }
        posses.remove(controllerPos);
        return ImmutableList.copyOf(posses);
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return DOWN_SLOTS;
        }
        if (side == this.facing.method_10170()) {
            return LEFT_SLOTS;
        }
        if (side == this.facing.method_10160() && this.currentSmeltTime == 0) {
            return Arrays.stream(RIGHT_SLOTS).filter(i -> !((Set)this.disabledSlots.get()).contains(i)).mapToInt(value -> value).toArray();
        }
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (slot == 11) {
            return ForgeFuelDataLoader.hasFuel(stack.method_7909());
        }
        if (((Set)this.disabledSlots.get()).contains(slot)) {
            return false;
        }
        class_1799 slotStack = this.method_5438(slot);
        return slotStack.method_7960() || ItemOps.canStack((class_1799)slotStack, (class_1799)stack);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 10 || slot == 11 && !ForgeFuelDataLoader.hasFuel(stack.method_7909());
    }

    public class_2561 method_5476() {
        return AlloyForgery.translation("title", "forge_controller", new Object[0]);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new AlloyForgeScreenHandler(syncId, inv, this);
    }
}

