/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.Strictness;
import com.mojang.logging.LogUtils;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.data.RecipeTagLoader;
import io.wispforest.alloyforgery.mixin.SingleStackRecipeAccessor;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipeSerializer;
import io.wispforest.alloyforgery.utils.RecipeInjector;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.format.gson.GsonDeserializer;
import io.wispforest.owo.serialization.RegistriesAttribute;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3859;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6903;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import org.slf4j.Logger;

public class BlastFurnaceRecipeAdapter
implements RecipeInjector.AddRecipes {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).create();
    private static final class_6862<class_1792> DUSTS_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"c", (String)"dusts"));
    public static final class_2960 BLACKLISTED_BLASTING_RECIPES = AlloyForgery.id("blacklisted_blasting_recipes");
    public static final class_2960 BLACKLISTED_INCREASED_OUTPUT = AlloyForgery.id("blacklisted_increased_blasting_outputs");
    private static final String ExtraRecipe = "ewogICJfY29tbWVudCI6ICJUaGlzIHJlY2lwZSBpcyBmb3IgYSBmcmllbmQgYW5kIGNvbnRhaW5zIG5vdGhpbmcgbWFsaWNpb3VzIHVubGVzcyBidXJudCBtZWF0IGlzIHNhZCBmb3IgeW91LiIsCiAgInR5cGUiOiAiYWxsb3lfZm9yZ2VyeTpmb3JnaW5nIiwKICAiaW5wdXRzIjogWwogICAgewogICAgICAiaW5ncmVkaWVudCI6ICIjbWluZWNyYWZ0Om1lYXQiLAogICAgICAiY291bnQiOiA0CiAgICB9CiAgXSwKICAib3V0cHV0IjogewogICAgIml0ZW0iOiAibWluZWNyYWZ0OmNoYXJjb2FsIiwKICAgICJjb3VudCI6IDEsCiAgICAiY29tcG9uZW50cyI6IHsKICAgICAgImN1c3RvbV9uYW1lIjogIlt7XCJ0ZXh0XCI6XCJDb29rZWRcIixcIml0YWxpY1wiOnRydWV9LCBcIiBcIiwge1widGV4dFwiOlwiU3RlYWtcIixcImNsaWNrRXZlbnRcIjp7XCJhY3Rpb25cIjpcIm9wZW5fdXJsXCIsXCJ2YWx1ZVwiOlwiaHR0cHM6Ly93d3cueW91dHViZS5jb20vd2F0Y2g/dj1kUXc0dzlXZ1hjUVwifSxcInN0cmlrZXRocm91Z2hcIjp0cnVlfV0iCiAgICB9CiAgfSwKICAib3ZlcnJpZGVzIjogewogICAgIjMiOiB7CiAgICAgICJpdGVtIjogIm1pbmVjcmFmdDpjaGFyY29hbCIsCiAgICAgICJjb3VudCI6IDIsCiAgICAgICJjb21wb25lbnRzIjogewogICAgICAgICJjdXN0b21fbmFtZSI6ICJbe1widGV4dFwiOlwiQ29va2VkXCIsXCJpdGFsaWNcIjp0cnVlfSwgXCIgXCIsIHtcInRleHRcIjpcIlN0ZWFrXCIsXCJjbGlja0V2ZW50XCI6e1wiYWN0aW9uXCI6XCJvcGVuX3VybFwiLFwidmFsdWVcIjpcImh0dHBzOi8vd3d3LnlvdXR1YmUuY29tL3dhdGNoP3Y9ZFF3NHc5V2dYY1FcIn0sXCJzdHJpa2V0aHJvdWdoXCI6dHJ1ZX1dIgogICAgICB9CiAgICB9LAogICAgIjQiOiB7CiAgICAgICJpdGVtIjogIm1pbmVjcmFmdDpwb2lzb25vdXNfcG90YXRvIiwKICAgICAgImNvdW50IjogMSwKICAgICAgImNvbXBvbmVudHMiOiB7CiAgICAgICAgImN1c3RvbV9uYW1lIjogIltcIm/PiW8sIGhvdyBkaWQgdGhpcyBoYXBwZW4/XCJdIgogICAgICB9CiAgICB9CiAgfSwKICAibWluX2ZvcmdlX3RpZXIiOiAyLAogICJmdWVsX3Blcl90aWNrIjogMjAKfQ==";

    @Override
    public void addRecipes(RecipeInjector instance) {
        if (!AlloyForgery.CONFIG.allowBlastingFurnaceAdaption()) {
            return;
        }
        class_1863 manager = instance.manager();
        Collection<class_8786<AlloyForgeRecipe>> alloyForgeryRecipes = instance.getAllOfType(AlloyForgeRecipe.Type.INSTANCE);
        for (class_8786 recipeEntry : instance.getAllOfType(class_3956.field_17547)) {
            class_3859 recipe = (class_3859)recipeEntry.comp_1933();
            if (!BlastFurnaceRecipeAdapter.isUniqueRecipe(instance, alloyForgeryRecipes, recipe) || RecipeTagLoader.isWithinTag(false, BLACKLISTED_BLASTING_RECIPES, recipeEntry)) continue;
            class_2960 secondaryID = recipeEntry.comp_1932().method_29177();
            String path = secondaryID.method_12832();
            if (path.contains("blasting")) {
                path = path.replace("blasting", "forging");
            }
            class_1799 mainOutput = ((SingleStackRecipeAccessor)recipe).result().method_7972();
            mainOutput.method_7939(AlloyForgery.CONFIG.baseInputAmount());
            ImmutableMap.Builder extraOutput = ImmutableMap.builder();
            if (AlloyForgery.CONFIG.allowHigherTierOutput() && !RecipeTagLoader.isWithinTag(false, BLACKLISTED_INCREASED_OUTPUT, recipeEntry) && !BlastFurnaceRecipeAdapter.isDustRecipe(instance, recipeEntry)) {
                class_1799 increasedOutput = mainOutput.method_7972();
                increasedOutput.method_7933(AlloyForgery.CONFIG.higherTierOutputIncrease());
                extraOutput.put((Object)new AlloyForgeRecipe.OverrideRange(3), (Object)increasedOutput);
            }
            class_2960 recipeId = AlloyForgery.id(path);
            AlloyForgeRecipe convertRecipe = new AlloyForgeRecipe(Map.of((class_1856)recipe.method_61671().method_64675().get(0), AlloyForgery.CONFIG.baseInputAmount()), mainOutput, 1, Math.round(BlastFurnaceRecipeAdapter.getFuelPerTick(recipe)), (Map<AlloyForgeRecipe.OverrideRange, class_1799>)extraOutput.build(), Optional.of(secondaryID));
            instance.addRecipe(recipeId, convertRecipe);
        }
        try {
            AlloyForgeRecipe funny = (AlloyForgeRecipe)AlloyForgeRecipeSerializer.RECIPE_ENDEC.decodeFully(SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.fromCachedInfoGetter((class_6903.class_9683)new class_6903.class_9683(instance.lookup()))}), GsonDeserializer::of, (Object)((JsonElement)GSON.fromJson(new String(Base64.getDecoder().decode(ExtraRecipe)), JsonElement.class)));
            instance.addRecipe(AlloyForgery.id("super_duper_fun_recipe"), funny);
        }
        catch (Throwable e) {
            LOGGER.error("{} recipe had a issue!", (Object)AlloyForgery.id("super_duper_fun_recipe"), (Object)e);
        }
    }

    private static float getFuelPerTick(class_3859 recipe) {
        return (float)recipe.method_8167() / 200.0f * 10.0f;
    }

    private static boolean isUniqueRecipe(RecipeInjector instance, Collection<class_8786<AlloyForgeRecipe>> alloyForgeryRecipes, class_1860<?> blastRecipe) {
        List<class_1799> stacks = instance.getStacks((class_1856)blastRecipe.method_61671().method_64675().get(0));
        List<class_8786> matchedRecipes = alloyForgeryRecipes.stream().filter(recipeEntry -> {
            AlloyForgeRecipe recipe = (AlloyForgeRecipe)recipeEntry.comp_1933();
            if (recipe.getIngredientsMap().size() > 1) {
                return false;
            }
            for (class_1799 stack : stacks) {
                if (!((class_1856)recipe.method_61671().method_64675().get(0)).method_8093(stack)) continue;
                return true;
            }
            return false;
        }).toList();
        return matchedRecipes.isEmpty();
    }

    private static boolean isDustRecipe(RecipeInjector instance, class_8786<class_3859> blastingRecipeEntry) {
        if (blastingRecipeEntry.comp_1932().method_29177().method_12832().contains("dust")) {
            return true;
        }
        class_3859 blastRecipe = (class_3859)blastingRecipeEntry.comp_1933();
        List<class_1799> stacks = instance.getStacks((class_1856)blastRecipe.method_61671().method_64675().get(0));
        for (class_1799 stack : stacks) {
            if (stack.method_31573(DUSTS_TAG)) {
                return true;
            }
            class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
            if (!id.method_12832().contains("dust")) continue;
            return true;
        }
        return false;
    }
}

