/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.utils.data;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.wispforest.alloyforgery.mixin.JsonDataLoaderAccessor;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.RegistriesAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class EndecDataLoader<T>
extends class_4309<T> {
    protected final String type;
    protected final class_2960 id;
    protected final Endec<T> endec;
    protected final Set<class_2960> dependencies;
    protected final SerializationContext context;
    protected final boolean requiresRegistries;
    @Nullable
    private class_7225.class_7874 registries = null;
    @Nullable
    private Function<class_3302.class_11558, class_7225.class_7874> registryGetter = null;

    private EndecDataLoader(class_2960 id, String type, Endec<T> endec, SerializationContext context, boolean requiresRegistries, Set<class_2960> value) {
        super(new DelayedRecursiveCodec(), class_7654.method_45114((String)type));
        this.id = id;
        this.type = type;
        this.endec = endec;
        this.context = context;
        this.requiresRegistries = requiresRegistries;
        this.dependencies = Collections.unmodifiableSet(value);
        this.setupCodec();
    }

    public static <T> Builder<T> builder(String type, Endec<T> endec) {
        return new Builder<T>(type, endec);
    }

    public class_2960 getLoaderId() {
        return this.id;
    }

    public Set<class_2960> getDependencyIds() {
        return this.dependencies;
    }

    public boolean requiresRegistries() {
        return this.requiresRegistries;
    }

    protected void setupCodec() {
        ((DelayedRecursiveCodec)((JsonDataLoaderAccessor)((Object)this)).codec()).setup(this.endec.toString(), codec -> CodecUtils.toCodec(this.endec, (SerializationContext)this.getContext()));
    }

    public void prepareSharedState(class_3302.class_11558 store) {
        if (this.requiresRegistries) {
            Objects.requireNonNull(this.registryGetter, "Can not get the needed context for the ManagedEndecDataLoader: " + String.valueOf(this.getLoaderId()));
            this.registries = this.registryGetter.apply(store);
            this.registryGetter = null;
            this.setupCodec();
        }
    }

    @ApiStatus.Internal
    public EndecDataLoader<T> setRegistryGetter(Function<class_3302.class_11558, class_7225.class_7874> registryGetter) {
        this.registryGetter = registryGetter;
        return this;
    }

    private SerializationContext getContext() {
        if (this.requiresRegistries) {
            Objects.requireNonNull(this.registries, "Can not build the needed context for the ManagedEndecDataLoader: " + String.valueOf(this.getLoaderId()));
            return this.context.withAttributes(new SerializationAttribute.Instance[]{RegistriesAttribute.fromCachedInfoGetter((class_6903.class_9683)new class_6903.class_9683(this.registries))});
        }
        return this.context;
    }

    protected Map<class_2960, T> method_20731(class_3300 resourceManager, class_3695 profiler) {
        if (this.requiresRegistries && this.registries == null) {
            throw new IllegalStateException("Unable to prepare files as the given Registry access has not been setup on the server! [Id: " + String.valueOf(this.getLoaderId()) + "]");
        }
        Map entries = super.method_20731(resourceManager, profiler);
        this.registries = null;
        return entries;
    }

    private static class DelayedRecursiveCodec<T>
    implements Codec<T> {
        private String name;
        private Supplier<Codec<T>> wrapped;

        private DelayedRecursiveCodec() {
        }

        public void setup(String name, Function<Codec<T>, Codec<T>> wrapped) {
            this.name = name;
            this.wrapped = Suppliers.memoize(() -> (Codec)wrapped.apply(this));
        }

        public <S> DataResult<Pair<T, S>> decode(DynamicOps<S> ops, S input) {
            return this.wrapped.get().decode(ops, input);
        }

        public <S> DataResult<S> encode(T input, DynamicOps<S> ops, S prefix) {
            return this.wrapped.get().encode(input, ops, prefix);
        }

        public String toString() {
            return "RecursiveCodec[" + this.name + "]";
        }
    }

    public static class Builder<T> {
        protected final String type;
        protected final Endec<T> endec;
        protected final Set<class_2960> dependencies = new HashSet<class_2960>();
        protected SerializationContext context = SerializationContext.empty();
        protected boolean requiresRegistries = false;

        Builder(String type, Endec<T> endec) {
            this.type = type;
            this.endec = endec;
        }

        public Builder<T> addDependencies(class_2960 ... dependencies) {
            return this.addDependencies(List.of(dependencies));
        }

        public Builder<T> addDependencies(Collection<class_2960> dependencies) {
            this.dependencies.addAll(dependencies);
            return this;
        }

        public Builder<T> requiresRegistries(boolean value) {
            this.requiresRegistries = value;
            return this;
        }

        public Builder<T> setContext(SerializationContext context) {
            this.context = context;
            return this;
        }

        public EndecDataLoader<T> create(class_2960 id, class_3264 packType, final LoadedDataHandler<T> handler) {
            EndecDataLoader loader = new EndecDataLoader<T>(this, id, this.type, this.endec, this.context, this.requiresRegistries, this.dependencies){

                protected void apply(Map<class_2960, T> prepared, class_3300 manager, class_3695 profiler) {
                    handler.handleData(prepared, manager, profiler);
                }
            };
            GeneralPlatformUtils.INSTANCE.registerLoader(id, packType, loader, this.requiresRegistries);
            return loader;
        }
    }

    public static interface LoadedDataHandler<T> {
        public void handleData(Map<class_2960, T> var1, class_3300 var2, class_3695 var3);
    }
}

