package io.wispforest.alloyforgery.block;

import F;
import J;
import Z;
import com.google.common.collect.ImmutableList;
import io.wispforest.alloyforgery.forges.*;
import io.wispforest.alloyforgery.forges.ForgeFuelDataLoader.ForgeFuelDefinition;
import io.wispforest.alloyforgery.utils.FluidStorage;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.owo.ops.ItemOps;
import io.wispforest.owo.util.ImplementedInventory;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;
import io.wispforest.alloyforgery.AlloyForgeScreenHandler;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.client.BlockEntityLocation;
import io.wispforest.alloyforgery.mixin.HopperBlockEntityAccessor;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipeInput;
import io.wispforest.alloyforgery.utils.ExtObservable;
import java.util.*;

@SuppressWarnings("UnstableApiUsage")
public class ForgeControllerBlockEntity extends class_2586 implements ImplementedInventory, class_1278, class_3908 {

    private static final int[] DOWN_SLOTS = new int[]{10, 11};
    private static final Integer[] RIGHT_SLOTS = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final int[] LEFT_SLOTS = new int[]{11};

    public static final int INVENTORY_SIZE = 12;
    public static class_2591<ForgeControllerBlockEntity> FORGE_CONTROLLER_BLOCK_ENTITY;
    private final class_2371<class_1799> items = class_2371.method_10213(INVENTORY_SIZE, class_1799.field_8037);

    public final ExtObservable<Set<Integer>> disabledSlots = ExtObservable.of(new HashSet<>());

    private final class_2371<class_1799> previousItems = class_2371.method_10211();
    private boolean checkForRecipes = true;

    private Optional<class_8786<AlloyForgeRecipe>> recipeCache = Optional.empty();

    public final ExtObservable<Integer> requiredTierToCraft = ExtObservable.of(-1);

    private final FluidStorage fluidHolder = GeneralPlatformUtils.INSTANCE.createStorage(this);

    private final class_2960 forgeDefinitionId;
    private final ImmutableList<class_2338> multiblockPositions;
    private final class_2350 facing;

    private float fuel;
    private int currentSmeltTime;

    // TODO: USE BASE VALUES AND ADD TOOLTIP INFO TO THE FORGES
    public final ExtObservable<Integer> smeltProgress = ExtObservable.of(0);
    public final ExtObservable<Integer> fuelProgress = ExtObservable.of(0);
    public final ExtObservable<Integer> lavaProgress = ExtObservable.of(0);

    public ForgeControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(FORGE_CONTROLLER_BLOCK_ENTITY, pos, state);
        forgeDefinitionId = ((ForgeControllerBlock) state.method_26204()).forgeDefinitionId;
        facing = state.method_11654(ForgeControllerBlock.FACING);

        multiblockPositions = generateMultiblockPositions(pos.method_10062(), state.method_11654(ForgeControllerBlock.FACING));
    }

    public ForgeTier forgeTier() {
        if (this.field_11863 == null) return ForgeTier.DEFAULT;

        var tier = ForgeTierDataLoader.getForgeRegistry(this.field_11863.method_8608()).getBoundForgeTier(this.forgeDefinitionId);

        if (tier == null) return ForgeTier.DEFAULT;

        return tier;
    }

    public BlockEntityLocation getExtraScreenData(class_3222 player) {
        return BlockEntityLocation.of(this);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5429(nbt, items, registryLookup);

        this.currentSmeltTime = nbt.method_10550("CurrentSmeltTime");
        this.fuel = nbt.method_10550("Fuel");

        final var fluidNbt = nbt.method_10562("FuelFluidInput");

        this.fluidHolder.readNbt(fluidNbt, registryLookup);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5426(nbt, items, registryLookup);

        nbt.method_10569("Fuel", Math.round(fuel));
        nbt.method_10569("CurrentSmeltTime", currentSmeltTime);

        final var fluidNbt = new class_2487();

        this.fluidHolder.writeNbt(fluidNbt, registryLookup);

        nbt.method_10566("FuelFluidInput", fluidNbt);
    }

    public <F extends FluidStorage> F getFluidHolder() {
        return (F) this.fluidHolder;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return items;
    }

    public class_1799 getFuelStack() {
        return method_5438(11);
    }

    public boolean canAddFuel(int fuel) {
        return this.fuel + fuel <= forgeTier().fuelCapacity();
    }

    public void addFuel(int fuel) {
        this.fuel += fuel;
    }

    public int getSmeltProgress() {
        return smeltProgress.get();
    }

    public int getCurrentSmeltTime() {
        return currentSmeltTime;
    }

    public ForgeDefinition getForgeDefinition() {
        return ForgeRegistry.getForgeDefinition(this.forgeDefinitionId)
            .orElseThrow(() -> new IllegalArgumentException("Unable to locate the given definition as its not registered! [Id: " + this.forgeDefinitionId + "]"));
    }

    public void disableSlot(int index) {
        this.disabledSlots.get().add(index);
        this.disabledSlots.markDirty();
    }

    public void enableSlot(int index) {
        this.disabledSlots.get().remove(index);
        this.disabledSlots.markDirty();
    }

    public int getCompartorOutput() {
        return this.getCurrentSmeltTime() != 0
            ? Math.max(1, Math.round(this.getSmeltProgress() * 0.46875f))
            : 0;
    }

    @Override
    public void method_5431() {
        if (ItemStackComparisonUtil.itemsChanged(items, previousItems)) {
            this.previousItems.clear();
            this.previousItems.addAll(items.stream().map(class_1799::method_7972).toList());

            this.checkForRecipes = true;
        }

        super.method_5431();
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        ImplementedInventory.super.method_5447(slot, stack);

        this.method_5431();
    }

    public void tick() {
        this.smeltProgress.set(Math.round((this.currentSmeltTime / (float) forgeTier().maxSmeltTime()) * 19));
        this.fuelProgress.set(Math.round((this.fuel / (float) forgeTier().fuelCapacity()) * 48));
        this.lavaProgress.set(Math.round(this.fluidHolder.fullnessAmount() * 50));

        field_11863.method_8455(field_11867, method_11010().method_26204());

        if (!this.verifyMultiblock()) {
            this.currentSmeltTime = 0;

            final var currentState = field_11863.method_8320(field_11867);
            if (currentState.method_11654(ForgeControllerBlock.LIT)) {
                field_11863.method_8501(field_11867, currentState.method_11657(ForgeControllerBlock.LIT, false));
            }

            return;
        }

        if (!this.getFuelStack().method_7960()) {
            final var fuelStack = this.getFuelStack();
            final var fuelDefinition = ForgeFuelDataLoader.getFuelForItem(fuelStack.method_7909());

            if (fuelDefinition != ForgeFuelDataLoader.ForgeFuelDefinition.EMPTY && canAddFuel(fuelDefinition.fuel())) {
                this.getFuelStack().method_7934(1);

                attemptInsertOnIndex(11, fuelDefinition.hasReturnType() ? new class_1799(fuelDefinition.returnType()) : class_1799.field_8037);

                this.fuel += fuelDefinition.fuel();
            }
        }

        // Failsafe just incase something was within the disabled slot and was disabled
        for (var i : this.disabledSlots.get()) {
            var stack = this.method_5438(i);

            if (!stack.method_7960()) insertIntoHopperOrScatterAtFront(stack);

            this.method_5447(i, class_1799.field_8037);
        }

        final var emptyFuelSpace = this.forgeTier().fuelCapacity() - this.fuel;

        var fluidAmount = this.fluidHolder.getFluidAmountInDroplets();

        if (fluidAmount >= 81 && emptyFuelSpace > 0f) {
            // Fuel Unit -> Millibuckets: / 24
            // Droplets  -> Millibuckets: / 81

            final float fuelInsertAmount = Math.min(fluidAmount / 81f, (emptyFuelSpace) / 24);

            this.fuel += fuelInsertAmount * 24;
            this.fluidHolder.setFluidAmountInDroplets((long) (fluidAmount - (fuelInsertAmount * 81)));
        }

        final var currentBlockState = this.field_11863.method_8320(field_11867);
        if (this.fuel > 100 && !currentBlockState.method_11654(ForgeControllerBlock.LIT)) {
            this.field_11863.method_8501(field_11867, currentBlockState.method_11657(ForgeControllerBlock.LIT, true));
        } else if (fuel < 100 && currentBlockState.method_11654(ForgeControllerBlock.LIT)) {
            this.field_11863.method_8501(field_11867, currentBlockState.method_11657(ForgeControllerBlock.LIT, false));
        }

        // 1: Check if the inventory is full
        // 2: Prevent crafting when we know that there is not enough fuel to craft at all
        // 3: Prevent recipe checking if the inventory has not changed
        if (this.method_5442()) {
            this.currentSmeltTime = 0;

            return;
        }

        if (this.fuel < 5 || !this.checkForRecipes) {
            this.currentSmeltTime = 0;

            return;
        }

        //--

        var recipeInput = new AlloyForgeRecipeInput(this);

        if (this.recipeCache.isEmpty() || !this.recipeCache.get().comp_1933().matches(recipeInput, this.field_11863)) {
            this.recipeCache = this.field_11863.method_8503().method_3772().method_8132(AlloyForgeRecipe.Type.INSTANCE, recipeInput, this.field_11863);
        }

        if (this.recipeCache.isEmpty() && this.requiredTierToCraft.get() != -1) {
            this.requiredTierToCraft.set(-1);
        }

        if (this.recipeCache.isEmpty() || !canSmelt(this.recipeCache.get().comp_1933())) {
            this.checkForRecipes = false;
            this.currentSmeltTime = 0;
            return;
        }

        //--

        var recipe = recipeCache.get().comp_1933();

        if (this.currentSmeltTime < this.forgeTier().maxSmeltTime()) {
            final float fuelRequirement = recipe.getFuelPerTick() * this.forgeTier().fuelConsumptionMultiplier();

            if (this.fuel - fuelRequirement < 0) {
                this.currentSmeltTime = 0;
                return;
            }

            this.currentSmeltTime++;
            this.fuel -= fuelRequirement;

            if (this.field_11863.field_9229.method_43058() > 0.75) {
                AlloyForgery.FORGE_PARTICLES.spawn(this.field_11863, class_243.method_24954(this.field_11867), this.facing);
            }
        } else {
            var remainderList = AlloyForgeRecipe.gatherRemainders(recipeCache.get(), recipeInput);

            if (remainderList != null) this.handleForgingRemainders(remainderList);

            var outputStack = this.method_5438(10);
            var recipeOutput = recipe.craft(recipeInput, this.field_11863.method_30349());

            recipe.consumeIngredients(recipeInput);

            if (outputStack.method_7960()) {
                this.method_5447(10, recipeOutput);
            } else {
                outputStack.method_7933(recipeOutput.method_7947());
            }

            this.currentSmeltTime = 0;
        }
    }

    private boolean canSmelt(AlloyForgeRecipe recipe) {
        final var outputStack = this.method_5438(10);
        final var recipeOutput = recipe.getResult(this.forgeTier().value());

        if (recipe.getMinForgeTier() > this.forgeTier().value()) {
            this.requiredTierToCraft.set(recipe.getMinForgeTier());

            return false;
        } else if (requiredTierToCraft.get() != -1) {
            this.requiredTierToCraft.set(-1);
        }

        return outputStack.method_7960() || ItemOps.canStack(outputStack, recipeOutput);
    }

    private void handleForgingRemainders(class_2371<class_1799> remainderList) {
        for (int i = 0; i < remainderList.size(); ++i) {
            attemptInsertOnIndex(i, remainderList.get(i));
        }
    }

    public void attemptInsertOnIndex(int i, class_1799 itemstack) {
        if (itemstack.method_7960()) return;

        var slotStack = this.method_5438(i);

        if (slotStack.method_7960()) {
            this.method_5447(i, itemstack);
        } else if (class_1799.method_7984(slotStack, itemstack) && class_1799.method_31577(slotStack, itemstack)) {
            itemstack.method_7933(slotStack.method_7947());

            if (itemstack.method_7947() > itemstack.method_7914()) {
                int excess = itemstack.method_7947() - itemstack.method_7914();
                itemstack.method_7934(excess);

                var insertStack = itemstack.method_7972();
                insertStack.method_7939(excess);

                insertIntoHopperOrScatterAtFront(insertStack);
            }

            this.method_5447(i, itemstack);
        } else {
            insertIntoHopperOrScatterAtFront(itemstack);
        }
    }

    private void insertIntoHopperOrScatterAtFront(class_1799 stack) {
        if (!this.attemptToInsertIntoHopper(stack)) {
            var frontForgePos = field_11867.method_10093(method_11010().method_11654(ForgeControllerBlock.FACING));

            field_11863.method_43128(null, frontForgePos.method_10263(), frontForgePos.method_10264(), frontForgePos.method_10260(), class_3417.field_15197, class_3419.field_15245, 1.0F, 0.2F);
            class_1264.method_5449(field_11863, frontForgePos.method_10263(), frontForgePos.method_10264(), frontForgePos.method_10260(), stack);
        }
    }

    @SuppressWarnings("BooleanMethodIsAlwaysInverted")
    private boolean attemptToInsertIntoHopper(class_1799 remainderStack) {
        if (remainderStack.method_7960()) return true;

        class_2614 blockEntity = null;

        for (int y = 1; y <= 2; y++) {
            if (field_11863.method_8321(this.field_11867.method_10087(y)) instanceof class_2614 hopperBlockEntity) {
                blockEntity = hopperBlockEntity;

                break;
            }
        }

        if (blockEntity != null) {
            var isHopperEmpty = blockEntity.method_5442();

            for (int slotIndex = 0; slotIndex < blockEntity.method_5439(); ++slotIndex) {
                if (remainderStack.method_7960()) break;

                if (!blockEntity.method_5438(slotIndex).method_7960()) {
                    final var itemStack = blockEntity.method_5438(slotIndex);

                    if (itemStack.method_7960()) {
                        blockEntity.method_5447(slotIndex, remainderStack);
                        remainderStack = class_1799.field_8037;
                    } else if (ItemOps.canStack(itemStack, remainderStack)) {
                        int availableSpace = itemStack.method_7914() - itemStack.method_7947();
                        int j = Math.min(itemStack.method_7947(), availableSpace);
                        remainderStack.method_7934(j);
                        itemStack.method_7933(j);
                    }
                } else {
                    blockEntity.method_5447(slotIndex, remainderStack);
                    break;
                }
            }

            if (isHopperEmpty && !((HopperBlockEntityAccessor) blockEntity).alloyForge$isDisabled()) {
                ((HopperBlockEntityAccessor) blockEntity).alloyForge$setTransferCooldown(8);
            }

            blockEntity.method_5431();

            return true;
        }

        return false;
    }

    @SuppressWarnings("BooleanMethodIsAlwaysInverted")
    public boolean verifyMultiblock() {
        final var belowController = field_11863.method_8320(multiblockPositions.get(0));
        final var forgeDefinition = getForgeDefinition();

        if (!(belowController.method_27852(class_2246.field_10312) || forgeDefinition.isBlockValid(belowController.method_26204())))
            return false;

        for (int i = 1; i < multiblockPositions.size(); i++) {
            if (!forgeDefinition.isBlockValid(field_11863.method_8320(multiblockPositions.get(i)).method_26204())) return false;
        }

        return true;
    }

    private static ImmutableList<class_2338> generateMultiblockPositions(class_2338 controllerPos, class_2350 controllerFacing) {
        final List<class_2338> posses = new ArrayList<>();
        final class_2338 center = controllerPos.method_10093(controllerFacing.method_10153());

        for (class_2338 pos : class_2338.method_10097(center.method_10069(1, -1, 1), center.method_10069(-1, -1, -1))) {
            posses.add(pos.method_10062());
        }

        posses.remove(controllerPos.method_10074());
        posses.add(0, controllerPos.method_10074());

        for (int i = 0; i < 2; i++) {
            final var newCenter = center.method_10069(0, i, 0);

            posses.add(newCenter.method_10078());
            posses.add(newCenter.method_10067());
            posses.add(newCenter.method_10095());
            posses.add(newCenter.method_10072());
        }

        posses.remove(controllerPos);
        return ImmutableList.copyOf(posses);
    }

    @Override
    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return DOWN_SLOTS;
        } else if (side == facing.method_10170()) {
            return LEFT_SLOTS;
        } else if (side == facing.method_10160() && this.currentSmeltTime == 0) {
            return Arrays.stream(RIGHT_SLOTS)
                .filter(i -> !this.disabledSlots.get().contains(i))
                .mapToInt(value -> value).toArray();
        } else {
            return new int[0];
        }
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (slot == 11) return ForgeFuelDataLoader.hasFuel(stack.method_7909());
        if (this.disabledSlots.get().contains(slot)) return false;

        var slotStack = method_5438(slot);

        return slotStack.method_7960() || ItemOps.canStack(slotStack, stack);
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 10 || (slot == 11 && !ForgeFuelDataLoader.hasFuel(stack.method_7909()));
    }

    @Override
    public class_2561 method_5476() {
        return AlloyForgery.translation("title", "forge_controller");
    }

    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new AlloyForgeScreenHandler(syncId, inv, this);
    }
}
