package io.wispforest.alloyforgery.compat;

import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.CodecUtils;
import java.util.stream.Stream;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10358;
import net.minecraft.class_1799;

public record CountedIngredientDisplay(class_10302 ingredient, int amount) implements class_10302 {
    public static final StructEndec<CountedIngredientDisplay> ENDEC = StructEndecBuilder.of(
            CodecUtils.toEndecWithRegistries(class_10302.field_54671, class_10302.field_54672).fieldOf("ingredient", CountedIngredientDisplay::ingredient),
            Endec.INT.fieldOf("amount", CountedIngredientDisplay::amount),
            CountedIngredientDisplay::new
    );

    public static final class_10312<CountedIngredientDisplay> SERIALIZER = new class_10312(CodecUtils.toMapCodec(ENDEC), CodecUtils.toPacketCodec(ENDEC));

    @Override
    public <T> Stream<T> method_64739(class_10352 parameters, class_10358<T> factory) {
        if (factory instanceof class_10302.class_10361) {
            return (Stream<T>) ingredient
                    .method_64739(parameters, class_10361.field_54901)
                    .map(t -> {
                        var stack = t.method_7972();

                        stack.method_7939(amount);

                        return stack;
                    });
        }

        return Stream.empty();
    }

    @Override
    public class_10312<CountedIngredientDisplay> method_64736() {
        return SERIALIZER;
    }
}
