package io.wispforest.alloyforgery.fabric;

import J;
import io.wispforest.alloyforgery.utils.FluidStorage;
import io.wispforest.endec.Endec;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.format.nbt.NbtDeserializer;
import io.wispforest.owo.serialization.format.nbt.NbtSerializer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_2487;
import net.minecraft.class_3612;
import net.minecraft.class_7225;
import java.util.Iterator;

public final class FluidHolderImpl extends SingleVariantStorage<FluidVariant> implements InsertionOnlyStorage<FluidVariant>, FluidStorage {
    public static final Endec<FluidVariant> FLUID_VARIANT = CodecUtils.toEndec(FluidVariant.CODEC).catchErrors((ctx, deserializer, e) -> FluidVariant.blank());

    private final Runnable onCommitAction;

    public FluidHolderImpl(Runnable onCommitAction) {
        this.onCommitAction = onCommitAction;
    }

    @Override
    protected FluidVariant getBlankVariant() {
        return FluidVariant.blank();
    }

    @Override
    protected long getCapacity(FluidVariant variant) {
        return FluidConstants.BUCKET + 81;
    }

    @Override
    protected void onFinalCommit() {
        onCommitAction.run();
    }

    @Override
    protected boolean canInsert(FluidVariant variant) {
        return variant.isOf(class_3612.field_15908);
    }

    @Override
    protected boolean canExtract(FluidVariant variant) {
        return false;
    }

    @Override
    public Iterator<StorageView<FluidVariant>> iterator() {
        return InsertionOnlyStorage.super.iterator();
    }

    //--

    @Override
    public void readNbt(class_2487 nbt, class_7225.class_7874 lookupProvider) {
        this.amount = nbt.method_10537("Amount");
        this.variant = FLUID_VARIANT.decodeFully(NbtDeserializer::of, nbt.method_10562("Variant"));
    }

    @Override
    public void writeNbt(class_2487 nbt, class_7225.class_7874 lookupProvider) {
        nbt.method_10544("Amount", this.amount);
        nbt.method_10566("Variant", FLUID_VARIANT.encodeFully(NbtSerializer::of, this.variant));
    }

    @Override
    public float fullnessAmount() {
        return this.getAmount() / (float) FluidConstants.BUCKET;
    }

    @Override
    public long getFluidAmountInDroplets() {
        return this.amount;
    }

    @Override
    public long setFluidAmountInDroplets(long amount) {
        var cappedAmount = Math.min(amount, this.getCapacity());
        var spilledAmount = amount - cappedAmount;

        this.amount = Math.min(amount, this.getCapacity());

        return spilledAmount <= 0 ? 0 : spilledAmount;
    }
}
