package io.wispforest.alloyforgery.forges;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableList.Builder;
import com.google.gson.*;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.format.gson.GsonEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.registration.ComplexRegistryAction;
import io.wispforest.owo.registration.RegistryHelper;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.utils.RecipeInjector;
import io.wispforest.alloyforgery.utils.data.EndecableModDataLoader;
import java.util.*;
import java.util.Map.Entry;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_6903;
import net.minecraft.class_7923;

public record ForgeDefinition(class_2248 material, ImmutableList<class_2248> additionalMaterials, boolean blockEntity) {

    private static final Logger LOGGER = LogUtils.getLogger();

    public ForgeDefinition(class_2248 material, ImmutableList<class_2248> additionalMaterials) {
        this(material, additionalMaterials, false);
    }

    public static final Endec<ForgeDefinition> FORGE_DEFINITION = MinecraftEndecs.IDENTIFIER.xmap(
        identifier -> {
            return ForgeRegistry.getForgeDefinition(identifier)
                .orElseThrow(() -> new IllegalStateException("Unable to locate ForgerDefinition with Identifier: [ID: " + identifier + "]"));
        }, forgeDefinition -> {
            return forgeDefinition.id()
                .orElseThrow(() -> new IllegalStateException("A Given forge Definition was not found within the ForgeRegistry!"));
        }
    );

    public Optional<class_2960> id() {
        return ForgeRegistry.getId(this);
    }

    @ApiStatus.Internal
    public static final Map<class_2960, ForgeTier> legacyForgeDefinitionIdToTier = new HashMap<>();

    @Deprecated
    @ApiStatus.Internal
    public static void loadAndEnqueue(class_2960 id, JsonObject json) {
        LOGGER.warn("A given Forge Definition '{}' has been loaded though a deprecated manor, please bug the author to switch over to the new system.", id);
        final int forgeTier = class_3518.method_15260(json, "tier");
        final float speedMultiplier = class_3518.method_15277(json, "speed_multiplier", 1);
        final int fuelCapacity = class_3518.method_15282(json, "fuel_capacity", 48000);

        // TODO: ADD DEPRECATION WARNING ABOUT LOADING TIER INFO
        var tier = new ForgeTier(id, forgeTier, speedMultiplier, fuelCapacity, Optional.empty());

        legacyForgeDefinitionIdToTier.put(id, tier);

        final var mainMaterialId = class_2960.method_12829(class_3518.method_15265(json, "material"));

        final var additionalMaterialIds = new ArrayList<class_2960>();
        class_3518.method_15292(json, "additional_materials", new JsonArray()).forEach(jsonElement -> additionalMaterialIds.add(class_2960.method_12829(jsonElement.getAsString())));

        loadAndEnqueue(id, new RawForgeDefinition(mainMaterialId, additionalMaterialIds, false));
    }

    @ApiStatus.Internal
    private static void loadAndEnqueue(class_2960 id, RawForgeDefinition rawForgeDefinition) {
        final var action = ComplexRegistryAction.Builder.create(() -> {
            final var mainMaterial = class_7923.field_41175.method_63535(rawForgeDefinition.materialId());
            final var additionalMaterialsBuilder = new ImmutableList.Builder<class_2248>();
            rawForgeDefinition.additionalMaterialIds().forEach(identifier -> additionalMaterialsBuilder.add(class_7923.field_41175.method_63535(identifier)));

            final var definition = new ForgeDefinition(mainMaterial, additionalMaterialsBuilder.build());

            ForgeRegistry.registerDefinition(id, definition);
        }).entries(rawForgeDefinition.blockIds()).build();

        RegistryHelper.get(class_7923.field_41175).runWhenPresent(action);
    }

    public boolean isBlockValid(class_2248 block) {
        return block == material || this.additionalMaterials.contains(block);
    }

    // TODO - kill
    //why kubejs why
    private static final String RECIPE_PATTERN =
        """
            {
                "type": "minecraft:crafting_shaped",
                "pattern": [
                    "###",
                    "#B#",
                    "###"
                ],
                "key": {
                    "#": "{material}",
                    "B": "minecraft:blast_furnace"
                },
                "result": {
                    "id": "{controller}",
                    "count": 1
                }
            }
            """;

    public JsonElement generateRecipe(class_2960 id) {
        String recipe = RECIPE_PATTERN.replace("{material}", class_7923.field_41178.method_10221(material.method_8389()).toString());
        recipe = recipe.replace("{controller}", class_7923.field_41178.method_10221(ForgeRegistry.getControllerBlock(id).get().method_8389()).toString());

        return ForgeRegistry.GSON.fromJson(recipe, JsonObject.class);
    }

    public static void runDataLoaders() {
        EndecableModDataLoader.of(
            AlloyForgery.id("old_forge_definition_loader"),
            "alloy_forges",
            GsonEndec.INSTANCE.xmap(JsonElement::getAsJsonObject, jsonObject -> jsonObject),
            ForgeDefinition::loadAndEnqueue
        ).load();

        EndecableModDataLoader.of(
            AlloyForgery.id("forge_definition_loader"),
            "alloy_forge/controller",
            RawForgeDefinition.ENDEC,
            ForgeDefinition::loadAndEnqueue
        ).load();
    }

    public static void injectRecipeAdditions() {
        RecipeInjector.ADD_RECIPES.register(instance -> {
            for (var forgeEntry : ForgeRegistry.getForgeEntries()) {
                var id = forgeEntry.getKey();

                try {
                    var recipe = class_1865.field_9035.method_53736()
                            .codec()
                            .decode(class_6903.method_46632(JsonOps.INSTANCE, instance.lookup()), forgeEntry.getValue().generateRecipe(id))
                            .getOrThrow(string -> new IllegalStateException("Unable to generate recipe for given ForgeDefinition [" + id + "]: " + string))
                            .getFirst();

                    instance.addRecipe(id.method_48331("_recipe"), recipe);
                } catch (Throwable e) {
                    LOGGER.error("{} recipe had a issue!", id, e);
                }
            }
        });
    }

    private record RawForgeDefinition(class_2960 materialId, List<class_2960> additionalMaterialIds, boolean isBlockEntity) {
        public static final StructEndec<RawForgeDefinition> ENDEC = StructEndecBuilder.of(
            MinecraftEndecs.IDENTIFIER.fieldOf("material", RawForgeDefinition::materialId),
            MinecraftEndecs.IDENTIFIER.listOf().optionalFieldOf("additional_materials", RawForgeDefinition::additionalMaterialIds, List.of()),
            Endec.BOOLEAN.optionalFieldOf("is_block_entity", RawForgeDefinition::isBlockEntity, false),
            RawForgeDefinition::new
        );

        public List<class_2960> blockIds() {
            var list = new ArrayList<>(additionalMaterialIds);
            list.addFirst(materialId);
            return list;
        }
    }

    @Override
    public String toString() {
        return "ForgeDefinition{" +
            "material=" + material +
            ", additionalMaterials=" + additionalMaterials +
            '}';
    }
}
