package io.wispforest.alloyforgery.forges;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.endec.Endec;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.util.TagInjector;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.ForgeControllerItem;
import io.wispforest.alloyforgery.block.ForgeControllerBlock;
import java.util.*;
import java.util.Map.Entry;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ForgeRegistry {

    public static Endec<ForgeDefinition> FORGE_DEFINITION = MinecraftEndecs.IDENTIFIER.xmap(
        identifier -> {
            return getForgeDefinition(identifier)
                .orElseThrow(() -> new IllegalStateException("Unable to locate ForgerDefinition with Identifier: [ID: " + identifier + "]"));
        }, forgeDefinition -> {
            for (var entry : getForgeEntries()) {
                if (entry.getValue() == forgeDefinition) return entry.getKey();
            }

            throw new IllegalStateException();
        }
    );

    public static final Gson GSON = new Gson();
    private static final class_2960 MINEABLE_PICKAXE = class_2960.method_60654("mineable/pickaxe");

    private static final Map<class_2960, ForgeDefinition> ID_TO_FORGE_DEFINITION = new LinkedHashMap<>();
    private static final Map<ForgeDefinition, class_2960> FORGE_DEFINITION_TO_ID = new LinkedHashMap<>();

    private static final Map<class_2960, class_2248> CONTROLLER_BLOCK_REGISTRY = new LinkedHashMap<>();

    public static final class EntryHolder {
        public final class_2960 controllerId;
        public final class_2960 forgeDefinitionId;
        private final Supplier<ForgeControllerBlock> controllerBlock;

        private EntryHolder(class_2960 forgeDefinitionId, class_2960 controllerId, BiFunction<class_2960, class_2960, ForgeControllerBlock> controllerBlock) {
            this.forgeDefinitionId = forgeDefinitionId;
            this.controllerId = controllerId;
            this.controllerBlock = Suppliers.memoize(() -> controllerBlock.apply(forgeDefinitionId, controllerId));
        }

        private class_1792 createItem() {
            return new ForgeControllerItem(
                controllerBlock(),
                new class_1792.class_1793()
                    .method_63686(class_5321.method_29179(class_7924.field_41197, controllerId))
                    .method_63685()
            );
        }

        public void registerItem() {
            class_2378.method_10230(class_7923.field_41178, controllerId, createItem());
        }

        public void registerBlock() {
            var controllerBlock = controllerBlock();

            class_2378.method_10230(class_7923.field_41175, controllerId, controllerBlock);

            TagInjector.inject(class_7923.field_41175, MINEABLE_PICKAXE, controllerBlock);

            CONTROLLER_BLOCK_REGISTRY.put(forgeDefinitionId, controllerBlock);
            GeneralPlatformUtils.INSTANCE.addToBlockEntity(ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY, controllerBlock);
        }

        public ForgeControllerBlock controllerBlock() {
            return controllerBlock.get();
        }
    }

    static void registerDefinition(class_2960 forgeDefinitionId, ForgeDefinition definition) {
        final var controllerId = AlloyForgery.id(class_7923.field_41175.method_10221(definition.material()).method_12832() + "_forge_controller");

        GeneralPlatformUtils.INSTANCE.handleDefinitionEntry(new EntryHolder(forgeDefinitionId, controllerId, ForgeControllerBlock::of));

        store(forgeDefinitionId, definition);
    }

    public static Optional<ForgeDefinition> getForgeDefinition(class_2960 id) {
        return ID_TO_FORGE_DEFINITION.containsKey(id) ? Optional.of(ID_TO_FORGE_DEFINITION.get(id)) : Optional.empty();
    }

    public static Optional<class_2248> getControllerBlock(class_2960 id) {
        return ID_TO_FORGE_DEFINITION.containsKey(id) ? Optional.of(CONTROLLER_BLOCK_REGISTRY.get(id)) : Optional.empty();
    }

    public static Optional<class_2960> getId(ForgeDefinition definition) {
        return FORGE_DEFINITION_TO_ID.containsKey(definition) ? Optional.of(FORGE_DEFINITION_TO_ID.get(definition)) : Optional.empty();
    }

    public static Set<Map.Entry<class_2960, ForgeDefinition>> getForgeEntries() {
        return ID_TO_FORGE_DEFINITION.entrySet();
    }

    public static Set<class_2960> getForgeIds() {
        return ID_TO_FORGE_DEFINITION.keySet();
    }

    public static List<class_2248> getControllerBlocks() {
        return CONTROLLER_BLOCK_REGISTRY.values().stream().toList();
    }

    private static void store(class_2960 id, ForgeDefinition definition) {
        FORGE_DEFINITION_TO_ID.put(definition, id);
        ID_TO_FORGE_DEFINITION.put(id, definition);
    }
}
