package io.wispforest.alloyforgery.mixin;

import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_5350;
import net.minecraft.class_8786;
import net.minecraft.class_9383;

@Mixin(class_5350.class)
public abstract class DataPackContentsMixin {

    @Shadow
    @Final
    private class_1863 recipeManager;
    @Shadow
    @Final
    private class_9383.class_9385 reloadableRegistries;

    @Inject(method = "applyPendingTagLoads", at = @At("TAIL"))
    private void alloy_forgery$onRefresh(CallbackInfo ci) {
        var recipeEntries = GeneralPlatformUtils.INSTANCE.getAllOfType(recipeManager, AlloyForgeRecipe.Type.INSTANCE);

        var map = new HashMap<AlloyForgeRecipe, class_2960>();

        for (var entry : recipeEntries) {
            map.put(entry.comp_1933(), entry.comp_1932().method_29177());
        }

        AlloyForgeRecipe.PENDING_RECIPES.forEach((recipe, pendingRecipeData) -> recipe.finishRecipe(this.reloadableRegistries.method_58294(), pendingRecipeData, key -> map.getOrDefault(key, class_2960.method_60655(AlloyForgery.MOD_ID, "unknown_recipe"))));

        AlloyForgeRecipe.PENDING_RECIPES.clear();
    }
}
