package io.wispforest.alloyforgery.mixin.registry;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import io.wispforest.alloyforgery.compat.LegacyIdMappings;
import net.minecraft.class_2348;
import net.minecraft.class_2960;

@Mixin(class_2348.class)
public abstract class DefaultedRegistryMixin {
    @ModifyVariable(at = @At("HEAD"), method = "get(Lnet/minecraft/util/Identifier;)Ljava/lang/Object;", ordinal = 0, argsOnly = true)
    private class_2960 fixMissingFromRegistry(@Nullable class_2960 id) {
        return LegacyIdMappings.remap(id);
    }
}
