/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery;

import com.google.common.reflect.Reflection;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import io.wispforest.alloyforgery.AlloyForgeScreenHandler;
import io.wispforest.alloyforgery.AlloyForgeryItemGroup;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.client.BlockEntityLocation;
import io.wispforest.alloyforgery.compat.AlloyForgeryConfig;
import io.wispforest.alloyforgery.compat.CountedIngredientDisplay;
import io.wispforest.alloyforgery.forges.ForgeDefinition;
import io.wispforest.alloyforgery.forges.ForgeFuelDataLoader;
import io.wispforest.alloyforgery.forges.ForgeTierDataLoader;
import io.wispforest.alloyforgery.networking.AlloyForgeNetworking;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipeSerializer;
import io.wispforest.alloyforgery.recipe.BlastFurnaceRecipeAdapter;
import io.wispforest.alloyforgery.utils.DataPackEvents;
import io.wispforest.alloyforgery.utils.GeneralPlatformUtils;
import io.wispforest.alloyforgery.utils.LoaderPlatformUtils;
import io.wispforest.alloyforgery.utils.RecipeInjector;
import io.wispforest.alloyforgery.utils.data.EndecDataLoader;
import io.wispforest.endec.Endec;
import io.wispforest.owo.particles.ClientParticles;
import io.wispforest.owo.particles.systems.ParticleSystem;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlloyForgery {
    public static final String MOD_ID = "alloy-forgery";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"alloy-forgery");
    public static final boolean DEBUG;
    public static final AlloyForgeryConfig CONFIG;
    private static final ParticleSystemController CONTROLLER;
    public static final ParticleSystem<class_2350> FORGE_PARTICLES;

    public static void init() {
        AlloyForgeNetworking.init();
        Endec remaindersEndec = Endec.map(item -> class_7923.field_41178.method_10221(item).toString(), id -> (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)id)), (Endec)CodecUtils.eitherEndec((Endec)CodecUtils.toEndec((Codec)class_1799.field_51397), (Endec)MinecraftEndecs.ofRegistry((class_2378)class_7923.field_41178)).xmap(either -> (class_1799)Either.unwrap((Either)either.mapRight(class_1792::method_7854)), Either::left));
        EndecDataLoader.builder("forge_remainder", remaindersEndec).create(class_2960.method_60655((String)MOD_ID, (String)"forge_remainder"), class_3264.field_14190, (data, manager, profiler) -> data.values().forEach(AlloyForgeRecipe::addRemainders));
        ForgeFuelDataLoader.init();
        ForgeTierDataLoader.init();
        Reflection.initialize((Class[])new Class[]{ForgeFuelDataLoader.class});
        RecipeInjector.ADD_RECIPES.register((Object)new BlastFurnaceRecipeAdapter());
        DataPackEvents.BEFORE_SYNC.register(RecipeInjector::injectRecipes);
        ForgeDefinition.injectRecipeAdditions();
    }

    public static void registerScreenHandlerType() {
        AlloyForgeScreenHandler.ALLOY_FORGE_SCREEN_HANDLER_TYPE = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)AlloyForgery.id("alloy_forge"), GeneralPlatformUtils.INSTANCE.createScreenHandlerType((syncId, inventory, location) -> new AlloyForgeScreenHandler(syncId, inventory, location.get(inventory.field_7546, ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY)), CodecUtils.toPacketCodec(BlockEntityLocation.ENDEC)));
    }

    public static void registerBlockEntities() {
        ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY = (class_2591)class_2378.method_10230((class_2378)class_7923.field_41181, (class_2960)AlloyForgery.id("forge_controller"), GeneralPlatformUtils.INSTANCE.createBlockEntityType(ForgeControllerBlockEntity::new));
    }

    public static void registerRecipeTypes() {
        class_2378.method_10230((class_2378)class_7923.field_41188, (class_2960)AlloyForgeRecipe.Type.ID, (Object)AlloyForgeRecipe.Type.INSTANCE);
    }

    public static void registerRecipeSerializers() {
        class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)AlloyForgeRecipe.Type.ID, (Object)((Object)AlloyForgeRecipeSerializer.INSTANCE));
    }

    public static void registerSlotDisplays() {
        class_2378.method_10230((class_2378)class_7923.field_54873, (class_2960)AlloyForgery.id("counted_ingredient"), CountedIngredientDisplay.SERIALIZER);
    }

    public static void registerItemGroup() {
        AlloyForgeryItemGroup.GROUP.initialize();
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static String translationKey(String suffix) {
        return "alloy-forgery." + suffix;
    }

    public static class_5250 translation(String prefix, String suffix, Object ... args) {
        return class_2561.method_43469((String)(prefix + ".alloy-forgery." + suffix), (Object[])args);
    }

    public static class_5250 tooltipTranslation(String suffix, Object ... args) {
        return AlloyForgery.translation("tooltip", suffix, args);
    }

    static {
        boolean debug = LoaderPlatformUtils.INSTANCE.isDevelopmentEnvironment();
        if (System.getProperty("alloy-forgery.debug") != null) {
            debug = Boolean.getBoolean("alloy-forgery.debug");
        }
        DEBUG = debug;
        CONFIG = AlloyForgeryConfig.createAndLoad();
        CONTROLLER = new ParticleSystemController(AlloyForgery.id("particles"));
        FORGE_PARTICLES = CONTROLLER.register(class_2350.class, (world, pos, facing) -> {
            class_243 particleSide = pos.method_1031(0.5 + (double)facing.method_10148() * 0.515, 0.25, 0.5 + (double)facing.method_10165() * 0.515);
            ClientParticles.spawnPrecise((class_2394)class_2398.field_11240, (class_1937)world, (class_243)particleSide, (double)((double)facing.method_10165() * 0.65), (double)0.175, (double)((double)facing.method_10148() * 0.65));
            ClientParticles.spawnPrecise((class_2394)class_2398.field_11251, (class_1937)world, (class_243)particleSide, (double)((double)facing.method_10165() * 0.65), (double)0.175, (double)((double)facing.method_10148() * 0.65));
        });
    }
}

