/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery;

import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.block.ForgeControllerBlock;
import io.wispforest.alloyforgery.forges.ForgeRegistry;
import io.wispforest.alloyforgery.forges.ForgeTier;
import io.wispforest.alloyforgery.forges.ForgeTierDataLoader;
import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.itemgroup.gui.ItemGroupButton;
import io.wispforest.owo.itemgroup.gui.ItemGroupTab;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class AlloyForgeryItemGroup {
    private static List<ItemStack> CONTROLLER_CACHE = null;
    public static final OwoItemGroup GROUP = OwoItemGroup.builder((ResourceLocation)AlloyForgery.id("main"), () -> {
        if (CONTROLLER_CACHE == null) {
            return null;
        }
        return Icon.of((ItemStack)(CONTROLLER_CACHE.isEmpty() ? Items.BARRIER.getDefaultInstance() : CONTROLLER_CACHE.get(0)));
    }).initializer(group -> {
        group.tabs.add(new ItemGroupTab(Icon.of((ItemStack)ItemStack.EMPTY), (Component)Component.empty(), (context, entries) -> {
            if (CONTROLLER_CACHE == null) {
                AlloyForgeryItemGroup.createControllerCache();
            }
            CONTROLLER_CACHE.forEach(arg_0 -> ((CreativeModeTab.Output)entries).accept(arg_0));
        }, ItemGroupTab.DEFAULT_TEXTURE, true));
        group.addButton(ItemGroupButton.github((CreativeModeTab)group, (String)"https://github.com/LordDeatHunter/Alloy-Forgery"));
        group.addButton(ItemGroupButton.curseforge((CreativeModeTab)group, (String)"https://www.curseforge.com/minecraft/mc-mods/alloy-forgery"));
        group.addButton(ItemGroupButton.modrinth((CreativeModeTab)group, (String)"https://modrinth.com/mod/alloy-forgery"));
        group.addButton(ItemGroupButton.discord((CreativeModeTab)group, (String)"https://discord.gg/Pa5wDVm8Xv"));
    }).build();

    private static void createControllerCache() {
        ArrayList<Block> blockList = new ArrayList<Block>(ForgeRegistry.getControllerBlocks());
        ForgeTierDataLoader tierRegistry = ForgeTierDataLoader.getForgeRegistry(true);
        blockList.sort(Comparator.comparingInt(value -> {
            ForgeTier tier = tierRegistry.getBoundForgeTier(((ForgeControllerBlock)value).forgeDefinitionId);
            if (tier == null) {
                tier = ForgeTier.DEFAULT;
            }
            return tier.value();
        }));
        CONTROLLER_CACHE = new ArrayList<ItemStack>(blockList.size());
        blockList.forEach(block -> CONTROLLER_CACHE.add(block.asItem().getDefaultInstance()));
    }
}

