/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.client;

import io.wispforest.alloyforgery.AlloyForgeScreenHandler;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.client.ComponentUtils;
import io.wispforest.alloyforgery.networking.AlloyForgeNetworking;
import io.wispforest.alloyforgery.networking.DisableSlotToggle;
import io.wispforest.alloyforgery.utils.ForgeInputSlot;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class AlloyForgeScreen
extends BaseOwoHandledScreen<FlowLayout, AlloyForgeScreenHandler> {
    private static final Material LAVA_SPRITE = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.parse((String)"block/lava_still"));
    private static final Component ENABLED_SLOT_TEXT = Component.translatable((String)"tooltip.alloy-forgery.enabled_slot");
    private static final Component DISABLED_SLOT_TEXT = Component.translatable((String)"tooltip.alloy-forgery.disabled_slot");
    private TextureComponent fuelGauge;
    private TextureComponent progressGauge;
    private TextureComponent invalidCross;
    private FlowLayout lavaBar;
    private boolean allowSlotToggling = false;

    public AlloyForgeScreen(AlloyForgeScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 189;
        this.titleLabelY = 69420;
        this.inventoryLabelY = this.imageHeight - 93;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((Screen)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        this.fuelGauge = (TextureComponent)Components.texture((ResourceLocation)ComponentUtils.themedTextureID("fuel_meter.png"), (int)22, (int)0, (int)22, (int)48, (int)44, (int)48).visibleArea(PositionedRectangle.of((int)0, (int)0, (int)22, (int)0)).configure(textureComponent -> textureComponent.positioning(Positioning.absolute((int)5, (int)22)).id("fuel-gauge"));
        this.progressGauge = (TextureComponent)Components.texture((ResourceLocation)ComponentUtils.textureID("forging_status.png"), (int)24, (int)3, (int)15, (int)19, (int)40, (int)22).visibleArea(PositionedRectangle.of((int)0, (int)0, (int)15, (int)0)).configure(textureComponent -> textureComponent.positioning(Positioning.absolute((int)147, (int)24)).id("progress-gauge"));
        this.invalidCross = (TextureComponent)Components.texture((ResourceLocation)ComponentUtils.textureID("cross.png"), (int)0, (int)0, (int)14, (int)14, (int)14, (int)14).visibleArea(PositionedRectangle.of((int)0, (int)0, (int)14, (int)0)).configure(textureComponent -> textureComponent.positioning(Positioning.absolute((int)147, (int)25)).id("invalid-cross"));
        this.lavaBar = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fixed((int)0), (Sizing)Sizing.fixed((int)10)).child((io.wispforest.owo.ui.core.Component)Components.sprite((Material)LAVA_SPRITE)).child((io.wispforest.owo.ui.core.Component)Components.sprite((Material)LAVA_SPRITE)).child((io.wispforest.owo.ui.core.Component)Components.sprite((Material)LAVA_SPRITE)).child((io.wispforest.owo.ui.core.Component)Components.sprite((Material)LAVA_SPRITE)).configure(layout -> layout.positioning(Positioning.absolute((int)63, (int)4)).id("lava-bar"));
        rootComponent.child(Containers.verticalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)189)).child((io.wispforest.owo.ui.core.Component)this.fuelGauge).child((io.wispforest.owo.ui.core.Component)this.progressGauge).child((io.wispforest.owo.ui.core.Component)this.invalidCross).child((io.wispforest.owo.ui.core.Component)this.lavaBar).child((io.wispforest.owo.ui.core.Component)Components.label((Component)Component.translatable((String)"title.alloy-forgery.forge_controller")).color(ComponentUtils.getThemedValue(Color.ofRgb((int)0x3F3F3F), Color.WHITE)).positioning(Positioning.relative((int)50, (int)12))).child(Containers.horizontalFlow((Sizing)Sizing.fixed((int)26), (Sizing)Sizing.content()).child(Components.button((Component)Component.empty(), btn -> {
            this.allowSlotToggling = !this.allowSlotToggling;
            btn.tooltip((Component)Component.translatable((String)("tooltip.alloy-forgery.slot_toggle_" + (this.allowSlotToggling ? "enable" : "disable"))));
        }).renderer((context, button, delta) -> {
            ComponentUtils.BUTTON_RENDERER.draw(context, button, delta);
            context.push().translate((float)button.getX(), (float)button.getY(), 0.0f);
            context.blit(RenderType::guiTextured, ComponentUtils.textureID("slot_locks.png"), 4, 3, this.allowSlotToggling ? 10.0f : 0.0f, 0.0f, 10, 12, 20, 12);
            context.pop();
        }).tooltip((Component)Component.translatable((String)"tooltip.alloy-forgery.slot_toggle_disable")).sizing(Sizing.fixed((int)18), Sizing.fixed((int)18))).horizontalAlignment(HorizontalAlignment.CENTER).positioning(Positioning.absolute((int)140, (int)75))).child(ComponentUtils.makeInputSlots(((AlloyForgeScreenHandler)this.getMenu()).getInputSlots(), 1, AlloyForgery.CONFIG::darkModeTheme, slot -> new BaseOwoHandledScreen.SlotComponent(this, slot.index){

            public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
                this.didDraw = true;
            }
        }, ((AlloyForgeScreenHandler)this.menu)::isSlotDisabled).positioning(Positioning.absolute((int)42, (int)41))).surface((context, component) -> {
            ResourceLocation backgroundTexture = ComponentUtils.themedTextureID("forge_controller_base.png");
            context.push().translate((float)component.x(), (float)component.y(), 0.0f);
            context.blit(RenderType::guiTextured, backgroundTexture, 0, 0, 0.0f, 0.0f, 176, 189, 176, 189);
            context.blit(RenderType::guiTextured, ComponentUtils.themedTextureID("fuel_meter.png"), 5, 22, 0.0f, 0.0f, 22, 48, 44, 48);
            context.blit(RenderType::guiTextured, ComponentUtils.textureID("forging_status.png"), 143, 21, 0.0f, 0.0f, 20, 22, 40, 22);
            context.pop();
        }).id("main-layout"));
        rootComponent.verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).surface(Surface.VANILLA_TRANSLUCENT);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.fuelGauge.visibleArea(PositionedRectangle.of((int)0, (int)(this.fuelGauge.height() - ((AlloyForgeScreenHandler)this.menu).getFuelProgress()), (Size)this.fuelGauge.fullSize()));
        this.progressGauge.visibleArea(PositionedRectangle.of((int)0, (int)0, (int)this.progressGauge.width(), (int)((AlloyForgeScreenHandler)this.menu).getSmeltProgress()));
        this.lavaBar.horizontalSizing(Sizing.fixed((int)((AlloyForgeScreenHandler)this.menu).getLavaProgress()));
        int requiredTier = ((AlloyForgeScreenHandler)this.menu).getRequiredTierData();
        if (requiredTier <= -1) {
            this.invalidCross.visibleArea(PositionedRectangle.of((int)0, (int)0, (int)0, (int)0)).tooltip(List.of());
        } else {
            this.invalidCross.resetVisibleArea().tooltip((Component)Component.translatable((String)"tooltip.alloy-forgery.invalid_tier", (Object[])new Object[]{requiredTier}));
        }
    }

    protected void renderTooltip(GuiGraphics context, int x, int y) {
        super.renderTooltip(context, x, y);
        if (this.allowSlotToggling && this.hoveredSlot instanceof ForgeInputSlot && ((AlloyForgeScreenHandler)this.menu).getCarried().isEmpty() && !this.hoveredSlot.hasItem() && !((AlloyForgeScreenHandler)this.menu).player().isSpectator()) {
            context.push().translate(0.0f, 0.0f, (float)this.getLayerZOffset(BaseOwoHandledScreen.HandledScreenLayer.ITEM_TOOLTIP));
            if (((AlloyForgeScreenHandler)this.menu).isSlotDisabled(this.hoveredSlot)) {
                context.renderTooltip(this.font, DISABLED_SLOT_TEXT, x, y);
            } else {
                context.renderTooltip(this.font, ENABLED_SLOT_TEXT, x, y);
            }
            context.pop();
        }
    }

    protected void slotClicked(Slot slot, int slotId, int button, ClickType actionType) {
        Player player = ((AlloyForgeScreenHandler)this.menu).player();
        if (this.allowSlotToggling && slot instanceof ForgeInputSlot && !slot.hasItem() && !player.isSpectator()) {
            if (actionType == ClickType.PICKUP) {
                if (((AlloyForgeScreenHandler)this.menu).isSlotDisabled(slot)) {
                    this.setSlotEnabled(slot, true);
                } else {
                    this.setSlotEnabled(slot, false);
                }
            } else if (actionType == ClickType.SWAP) {
                ItemStack itemStack = player.getInventory().getItem(button);
                if (((AlloyForgeScreenHandler)this.menu).isSlotDisabled(slot) && !itemStack.isEmpty()) {
                    this.setSlotEnabled(slot, true);
                }
            }
        }
        super.slotClicked(slot, slotId, button, actionType);
    }

    private void setSlotEnabled(Slot slot, boolean enabled) {
        AlloyForgeNetworking.CHANNEL.clientHandle().send((Record)new DisableSlotToggle(((AlloyForgeScreenHandler)this.menu).forge, (Integer)slot.getContainerSlot(), (Boolean)(!enabled ? 1 : 0)));
        super.handleSlotStateChanged(slot.index, ((AlloyForgeScreenHandler)this.menu).containerId, enabled);
        float f = enabled ? 1.0f : 0.75f;
        ((AlloyForgeScreenHandler)this.menu).player().playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.4f, f);
    }

    public int rootX() {
        return this.leftPos;
    }

    public int rootY() {
        return this.topPos;
    }
}

