/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.compat.rei;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.wispforest.alloyforgery.compat.CountedIngredientDisplay;
import io.wispforest.alloyforgery.compat.rei.AlloyForgeryCommonPlugin;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import org.jetbrains.annotations.Nullable;

public record AlloyForgingDisplay(List<EntryIngredient> inputs, EntryIngredient output, int minForgeTier, int fuelPerTick, Map<AlloyForgeRecipe.OverrideRange, ItemStack> overrides, Optional<ResourceLocation> recipeID) implements Display
{
    public static final Endec<EntryIngredient> ENTRY_INGREDIENT_ENDEC = CodecUtils.toEndecWithRegistries((Codec)EntryIngredient.codec(), (StreamCodec)EntryIngredient.streamCodec());
    public static final StructEndec<AlloyForgingDisplay> ENDEC = StructEndecBuilder.of((StructField)ENTRY_INGREDIENT_ENDEC.listOf().fieldOf("inputs", display -> display.inputs), (StructField)ENTRY_INGREDIENT_ENDEC.fieldOf("output", display -> display.output), (StructField)Endec.INT.fieldOf("min_forge_tier", display -> display.minForgeTier), (StructField)Endec.INT.fieldOf("fuel_per_tick", display -> display.fuelPerTick), (StructField)Endec.map(AlloyForgeRecipe.OverrideRange.OVERRIDE_RANGE, (Endec)MinecraftEndecs.ITEM_STACK).fieldOf("overrides", display -> display.overrides), (StructField)MinecraftEndecs.IDENTIFIER.optionalOf().fieldOf("recipe_id", display -> display.recipeID), AlloyForgingDisplay::new);
    public static final DisplaySerializer<AlloyForgingDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)CodecUtils.toMapCodec(ENDEC), (StreamCodec)CodecUtils.toPacketCodec(ENDEC));

    public static AlloyForgingDisplay of(RecipeHolder<AlloyForgeRecipe> recipeEntry) {
        ArrayList<EntryIngredient> convertedInputs = new ArrayList<EntryIngredient>();
        AlloyForgeRecipe recipe = (AlloyForgeRecipe)recipeEntry.value();
        for (Map.Entry<Ingredient, Integer> entry : recipe.getIngredientsMap().entrySet()) {
            int stackCount;
            for (int i = entry.getValue().intValue(); i > 0; i -= stackCount) {
                stackCount = Math.min(i, 64);
                convertedInputs.add(EntryIngredients.ofSlotDisplay((SlotDisplay)new CountedIngredientDisplay(entry.getKey().display(), stackCount)));
            }
        }
        return new AlloyForgingDisplay((List<EntryIngredient>)convertedInputs, EntryIngredients.of((ItemStack)recipe.getBaseResult()), recipe.getMinForgeTier(), recipe.getFuelPerTick(), (Map<AlloyForgeRecipe.OverrideRange, ItemStack>)recipe.getTierOverrides(), recipe.secondaryID().or(() -> Optional.of(recipeEntry.id().location())));
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(this.output);
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return AlloyForgeryCommonPlugin.ID;
    }

    public Optional<ResourceLocation> getDisplayLocation() {
        return this.recipeID;
    }

    @Nullable
    public DisplaySerializer<AlloyForgingDisplay> getSerializer() {
        return SERIALIZER;
    }
}

