/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.data;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.DependencySorter;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DelayedTagGroupLoader<T>
extends TagLoader<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private Function<ResourceLocation, Optional<? extends T>> registryGetter = null;
    private final String dataType;

    public DelayedTagGroupLoader(String dataType) {
        super((id, required) -> Optional.empty(), dataType);
        this.dataType = dataType;
    }

    public DelayedTagGroupLoader<T> setGetter(Function<ResourceLocation, Optional<? extends T>> registryGetter) {
        this.registryGetter = registryGetter;
        return this;
    }

    private Tuple<List<TagLoader.EntryWithSource>, List<T>> resolveAll(TagEntry.Lookup<T> valueGetter, List<TagLoader.EntryWithSource> entries) {
        LinkedHashSet sequencedSet = new LinkedHashSet();
        ArrayList<TagLoader.EntryWithSource> list = new ArrayList<TagLoader.EntryWithSource>();
        for (TagLoader.EntryWithSource trackedEntry : entries) {
            if (trackedEntry.entry().build(valueGetter, sequencedSet::add)) continue;
            list.add(trackedEntry);
        }
        return new Tuple(list, List.copyOf(sequencedSet));
    }

    public Map<ResourceLocation, List<T>> build(Map<ResourceLocation, List<TagLoader.EntryWithSource>> tags) {
        if (this.registryGetter == null) {
            throw new RuntimeException("DelayedTagGroupLoader did not have the required registeryGetter set to resolve! [Type: " + this.dataType + "]");
        }
        final HashMap map = Maps.newHashMap();
        TagEntry.Lookup valueGetter = new TagEntry.Lookup<T>(){

            @Nullable
            public T element(ResourceLocation id, boolean required) {
                return DelayedTagGroupLoader.this.registryGetter.apply(id).orElse(null);
            }

            @Nullable
            public Collection<T> tag(ResourceLocation id) {
                return (Collection)map.get(id);
            }
        };
        DependencySorter dependencyTracker = new DependencySorter();
        tags.forEach((id, entries) -> dependencyTracker.addEntry(id, (DependencySorter.Entry)new TagLoader.SortingEntry(entries)));
        dependencyTracker.orderByDependencies((arg_0, arg_1) -> this.lambda$buildGroup$2((TagEntry.Lookup)valueGetter, map, arg_0, arg_1));
        return map;
    }

    private /* synthetic */ void lambda$buildGroup$2(TagEntry.Lookup valueGetter, Map map, ResourceLocation id, TagLoader.SortingEntry dependencies) {
        Tuple<List<TagLoader.EntryWithSource>, List<T>> pair = this.resolveAll(valueGetter, dependencies.entries());
        List missingReferences = (List)pair.getA();
        if (!missingReferences.isEmpty()) {
            LOGGER.error("Couldn't load the given entries within tag {}: {}", (Object)id, (Object)missingReferences.stream().map(Objects::toString).collect(Collectors.joining(", ")));
        }
        map.put(id, (List)pair.getB());
    }
}

