/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.neoforge;

import io.wispforest.alloyforgery.utils.FluidStorage;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidHolderImpl
implements IFluidHandler,
IFluidTank,
FluidStorage {
    protected FluidStack fluid = new FluidStack((Fluid)Fluids.LAVA, 0);
    protected long amountInDroplets = 0L;
    private final Runnable onCommitAction;
    private final long capacity = 81081L;

    public FluidHolderImpl(Runnable onCommitAction) {
        this.onCommitAction = onCommitAction;
    }

    private void setAmountOnStack() {
        this.fluid.setAmount(this.getFluidAmount());
    }

    public FluidStack getFluid() {
        this.setAmountOnStack();
        return this.fluid;
    }

    @Override
    public void readNbt(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        this.amountInDroplets = nbt.getLong("Amount");
        int amount = this.fluid.getAmount();
        Holder.Reference variant = (Holder.Reference)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)nbt.getString("Variant"))).orElseThrow();
        this.fluid = new FluidStack((Holder)variant, amount);
    }

    @Override
    public void writeNbt(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        nbt.putLong("Amount", this.amountInDroplets);
        nbt.putString("Variant", this.fluid.getFluidHolder().getRegisteredName());
    }

    @Override
    public float fullnessAmount() {
        return (float)this.amountInDroplets / 81000.0f;
    }

    @Override
    public long getFluidAmountInDroplets() {
        return this.amountInDroplets;
    }

    @Override
    public long setFluidAmountInDroplets(long amount) {
        long cappedAmount = Math.min(amount, 6567641L);
        long spilledAmount = amount - cappedAmount;
        this.amountInDroplets = cappedAmount;
        this.setAmountOnStack();
        return spilledAmount;
    }

    public int getFluidAmount() {
        return (int)Math.ceil((double)this.getFluidAmountInDroplets() / 81.0);
    }

    public int getCapacity() {
        return Math.toIntExact(1001L);
    }

    public boolean isFluidValid(FluidStack fluidStack) {
        return fluidStack.is((Fluid)Fluids.LAVA);
    }

    private boolean isEmpty() {
        return this.fluid == FluidStack.EMPTY || this.fluid.getFluid() == Fluids.EMPTY || this.amountInDroplets <= 0L;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int filledMilliBuckets;
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        int capacity = this.getCapacity();
        long resourceAmountInDroplets = (long)resource.getAmount() * 81L;
        if (action.simulate()) {
            if (this.isEmpty()) {
                return Math.min(capacity, resource.getAmount());
            }
            if (!FluidStack.isSameFluidSameComponents((FluidStack)this.fluid, (FluidStack)resource)) {
                return 0;
            }
            return Math.min(capacity - this.getFluidAmount(), resource.getAmount());
        }
        if (this.isEmpty()) {
            this.amountInDroplets = Math.min(this.capacity, resourceAmountInDroplets);
            this.fluid = resource.copyAndClear();
            this.setAmountOnStack();
            this.onCommitAction.run();
            return (int)Math.ceil((double)this.amountInDroplets / 81.0);
        }
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.fluid, (FluidStack)resource)) {
            return 0;
        }
        long filled = this.capacity - this.amountInDroplets;
        if (resourceAmountInDroplets < filled) {
            this.amountInDroplets += resourceAmountInDroplets;
            filledMilliBuckets = resource.getAmount();
        } else {
            this.amountInDroplets = this.capacity + filled % 81L;
            filledMilliBuckets = this.getCapacity();
        }
        this.setAmountOnStack();
        if (filled > 0L) {
            this.onCommitAction.run();
        }
        return filledMilliBuckets;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int i) {
        return this.getFluid();
    }

    public int getTankCapacity(int i) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int i, FluidStack fluidStack) {
        return this.isFluidValid(fluidStack);
    }
}

