/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.alloyforgery.utils.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import io.wispforest.endec.Endec;
import io.wispforest.endec.format.gson.GsonDeserializer;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public record EndecedHandler<T>(Endec<T> endec, BiConsumer<ResourceLocation, T> handler) {
    public void handle(ResourceLocation id, JsonElement jsonElement) {
        try {
            this.handler().accept(id, (ResourceLocation)this.endec().decodeFully(GsonDeserializer::of, (Object)jsonElement));
        }
        catch (JsonSyntaxException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    public static <T> EndecedHandler<Optional<T>> of(String fieldName, Endec<T> endec, BiConsumer<ResourceLocation, T> consumer, Consumer<ResourceLocation> onEmptyMsg) {
        return new EndecedHandler<Optional<T>>(StructEndecBuilder.of((StructField)endec.fieldOf(fieldName, Optional::get), Optional::of), (entryId, t) -> t.ifPresentOrElse(t1 -> consumer.accept((ResourceLocation)entryId, (Object)t1), () -> onEmptyMsg.accept((ResourceLocation)entryId)));
    }
}

