package io.wispforest.alloyforgery;

import io.wispforest.endec.Endec;
import io.wispforest.owo.client.screens.*;
import io.wispforest.owo.util.EventStream;
import org.jetbrains.annotations.Nullable;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import io.wispforest.alloyforgery.forges.ForgeFuelDataLoader;
import io.wispforest.alloyforgery.utils.ExtObservable;
import io.wispforest.alloyforgery.utils.ForgeInputSlot;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public class AlloyForgeScreenHandler extends class_1703 {

    public static class_3917<AlloyForgeScreenHandler> ALLOY_FORGE_SCREEN_HANDLER_TYPE;
    private final class_1263 controllerInventory;

    private final boolean isServer;

    public final ForgeControllerBlockEntity forge;

    private final SyncedProperty<Integer> smeltProgress;
    private final SyncedProperty<Integer> fuelProgress;
    private final SyncedProperty<Integer> lavaProgress;
    private final SyncedProperty<Integer> requiredTierToCraft;

    private final SyncedProperty<Set<Integer>> disabledSlots;

    private final List<class_1735> inputSlots;

    public AlloyForgeScreenHandler(int syncId, class_1661 playerInventory, ForgeControllerBlockEntity forge) {
        super(ALLOY_FORGE_SCREEN_HANDLER_TYPE, syncId);

        this.isServer = playerInventory.field_7546 instanceof class_3222;

        this.forge = forge;

        this.controllerInventory = (forge != null) ? forge : new class_1277(ForgeControllerBlockEntity.INVENTORY_SIZE);

        this.smeltProgress = createProperty(Integer.class, forge, (provider) -> provider.smeltProgress, 0);
        this.fuelProgress = createProperty(Integer.class, forge, (provider) -> provider.fuelProgress, 0);
        this.lavaProgress = createProperty(Integer.class, forge, (provider) -> provider.lavaProgress, 0);
        this.requiredTierToCraft = createProperty(Integer.class, forge, (provider) -> provider.requiredTierToCraft, -1);

        this.disabledSlots = createSetProperty(Integer.class, forge, (provider) -> provider.disabledSlots);

        //Fuel Slot
        this.method_7621(new class_1735(controllerInventory, 11, 8, 74) {
            @Override
            public boolean method_7680(class_1799 stack) {
                return ForgeFuelDataLoader.hasFuel(stack.method_7909());
            }
        });

        //Recipe Output
        this.method_7621(new class_1735(controllerInventory, 10, 145, 50) {
            @Override
            public boolean method_7680(class_1799 stack) {
                return false;
            }
        });

        SlotGenerator.begin(this::method_7621, 44, 43)
            .slotFactory((inventory, index, x, y) -> new ForgeInputSlot(inventory, index, x, y, this))
            .grid(controllerInventory, 0, 5, 2)
            .defaultSlotFactory()
            .moveTo(8, 107)
            .playerInventory(playerInventory);

        this.inputSlots = this.field_7761.stream().filter(slot -> slot instanceof ForgeInputSlot).toList();;
    }

    //--

    private final EventStream<Runnable> onClosedEvent = new EventStream<>(closeRuns -> () -> closeRuns.forEach(Runnable::run));

    public <P, T> SyncedProperty<Set<T>> createSetProperty(Class<T> elementType, @Nullable P provider, Function<P, ExtObservable<Set<T>>> observableProviderFunc) {
        var type = createParameterizedType(Set.class, elementType);

        return (SyncedProperty<Set<T>>) (Object) createProperty(
            Set.class,
            (Endec<Set>) this.endecBuilder().get(type),
            provider,
            observableProviderFunc.andThen(listExtObservable -> (ExtObservable<Set>) (Object) listExtObservable),
            set -> new HashSet<>(set),
            new HashSet<>());
    }

    public <P, T> SyncedProperty<List<T>> createListProperty(Class<T> elementType, @Nullable P provider, Function<P, ExtObservable<List<T>>> observableProviderFunc) {
        var type = createParameterizedType(List.class, elementType);

        return (SyncedProperty<List<T>>) (Object) createProperty(
            List.class,
            (Endec<List>) this.endecBuilder().get(type),
            provider,
            observableProviderFunc.andThen(listExtObservable -> (ExtObservable<List>) (Object) listExtObservable),
            list -> new ArrayList<>(list),
            new ArrayList<>());
    }

    private static ParameterizedType createParameterizedType(Type rawType, Type ...typeArgs) {
        if (typeArgs.length == 0) throw new IllegalStateException("Unable to create ParameterizedType with zero type args!");

        return new ParameterizedType() {
            @Override public Type[] getActualTypeArguments() { return typeArgs; }
            @Override public Type getRawType() { return rawType; }
            @Override public Type getOwnerType() { return null; }
        };
    }

    public <P, T> SyncedProperty<T> createProperty(Class<T> clazz, @Nullable P provider, Function<P, ExtObservable<T>> observableProviderFunc, T initial) {
        return createProperty(clazz, this.endecBuilder().get(clazz), provider, observableProviderFunc, t -> t, initial);
    }

    public <P, T> SyncedProperty<T> createProperty(Class<T> clazz, @Nullable P provider, Function<P, ExtObservable<T>> observableProviderFunc, Function<T, T> cloneFunc, T initial) {
        return createProperty(clazz, this.endecBuilder().get(clazz), provider, observableProviderFunc, cloneFunc, initial);
    }

    public <P, T> SyncedProperty<T> createProperty(Class<T> clazz, Endec<T> endec, @Nullable P provider, Function<P, ExtObservable<T>> observableProviderFunc, Function<T, T> cloneFunc, T initial) {
        return (provider != null && this.isServer)
            ? createProperty(clazz, endec, observableProviderFunc.apply(provider), cloneFunc)
            : createProperty(clazz, endec, initial);
    }

    public <T> SyncedProperty<T> createProperty(Class<T> clazz, ExtObservable<T> initial, Function<T, T> cloneFunc) {
        return createProperty(clazz, this.endecBuilder().get(clazz), initial, cloneFunc);
    }

    public <T> SyncedProperty<T> createProperty(Class<T> clazz, Endec<T> endec, ExtObservable<T> initial, Function<T, T> cloneFunc) {
        var property = this.createProperty(clazz, endec, cloneFunc.apply(initial.get()));

        property.markDirty();

        this.onClosedEvent.source().subscribe(initial.observeSub(t -> property.set(cloneFunc.apply(t)))::cancel);

        return property;
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);

        this.onClosedEvent.sink().run();
    }

    //--

    @Override
    public class_1799 method_7601(class_1657 player, int invSlot) {
        return ScreenUtils.handleSlotTransfer(this, invSlot, this.controllerInventory.method_5439());
    }

    public int getSmeltProgress() {
        return this.smeltProgress.get();
    }

    public int getFuelProgress() {
        return this.fuelProgress.get();
    }

    public int getLavaProgress() {
        return this.lavaProgress.get();
    }

    public int getRequiredTierData() {
        return this.requiredTierToCraft.get();
    }

    public boolean isSlotDisabled(class_1735 slot) {
        return this.disabledSlots.get().contains(slot.method_34266());
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return this.controllerInventory.method_5443(player);
    }

    public class_1263 getControllerInventory() {
        return this.controllerInventory;
    }

    public List<class_1735> getInputSlots() {
        return this.inputSlots;
    }
}
