package io.wispforest.alloyforgery;

import com.google.common.reflect.Reflection;
import com.mojang.datafixers.util.Either;
import io.wispforest.alloyforgery.client.BlockEntityLocation;
import io.wispforest.alloyforgery.compat.AlloyForgeryConfig;
import io.wispforest.alloyforgery.utils.DataPackEvents;
import io.wispforest.alloyforgery.utils.LoaderPlatformUtils;
import io.wispforest.endec.Endec;
import io.wispforest.owo.particles.ClientParticles;
import io.wispforest.owo.particles.systems.ParticleSystem;
import io.wispforest.owo.particles.systems.ParticleSystemController;
import io.wispforest.owo.serialization.CodecUtils;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.alloyforgery.block.ForgeControllerBlockEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import io.wispforest.alloyforgery.compat.CountedIngredientDisplay;
import io.wispforest.alloyforgery.forges.ForgeDefinition;
import io.wispforest.alloyforgery.forges.ForgeFuelDataLoader;
import io.wispforest.alloyforgery.forges.ForgeTierDataLoader;
import io.wispforest.alloyforgery.networking.AlloyForgeNetworking;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipe;
import io.wispforest.alloyforgery.recipe.AlloyForgeRecipeSerializer;
import io.wispforest.alloyforgery.recipe.BlastFurnaceRecipeAdapter;
import io.wispforest.alloyforgery.utils.RecipeInjector;
import io.wispforest.alloyforgery.utils.data.EndecDataLoader;

import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

import static io.wispforest.alloyforgery.utils.GeneralPlatformUtils.INSTANCE;

public class AlloyForgery {

    public static final String MOD_ID = "alloy-forgery";

    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    /**
     * Whether the given mods debug is enabled, this defaults to {@code true} in a development environment.
     */
    public static final boolean DEBUG;

    static {
        boolean debug = LoaderPlatformUtils.INSTANCE.isDevelopmentEnvironment();
        if (System.getProperty(MOD_ID + ".debug") != null) debug = Boolean.getBoolean(MOD_ID + ".debug");

        DEBUG = debug;
    }

    public static final AlloyForgeryConfig CONFIG = AlloyForgeryConfig.createAndLoad();

    private static final ParticleSystemController CONTROLLER = new ParticleSystemController(id("particles"));
    public static final ParticleSystem<class_2350> FORGE_PARTICLES = CONTROLLER.register(class_2350.class, (world, pos, facing) -> {
        final class_243 particleSide = pos.method_1031(0.5 + facing.method_10148() * 0.515, 0.25, 0.5 + facing.method_10165() * 0.515);
        ClientParticles.spawnPrecise(class_2398.field_11240, world, particleSide,
            facing.method_10165() * 0.65,
            0.175,
            facing.method_10148() * 0.65);

        ClientParticles.spawnPrecise(class_2398.field_11251, world, particleSide,
            facing.method_10165() * 0.65,
            0.175,
            facing.method_10148() * 0.65);
    });

    @SuppressWarnings("UnstableApiUsage")
    public static void init() {
        AlloyForgeNetworking.init();

        Endec<Map<class_1792, class_1799>> remaindersEndec = Endec.map(
                item -> class_7923.field_41178.method_10221(item).toString(),
                id -> class_7923.field_41178.method_63535(class_2960.method_60654(id)),
                CodecUtils.eitherEndec(CodecUtils.toEndec(class_1799.field_51397), MinecraftEndecs.ofRegistry(class_7923.field_41178))
                        .xmap(either -> Either.unwrap(either.mapRight(class_1792::method_7854)), Either::left)
        );

        EndecDataLoader.builder("forge_remainder", remaindersEndec)
            .create(class_2960.method_60655(MOD_ID, "forge_remainder"), class_3264.field_14190, (data, manager, profiler) -> {
                data.values().forEach(AlloyForgeRecipe::addRemainders);
            });

        ForgeFuelDataLoader.init();
        ForgeTierDataLoader.init();

        Reflection.initialize(ForgeFuelDataLoader.class);

        RecipeInjector.ADD_RECIPES.register(new BlastFurnaceRecipeAdapter());
        DataPackEvents.BEFORE_SYNC.register(RecipeInjector::injectRecipes);

        ForgeDefinition.injectRecipeAdditions();
    }

    public static void registerScreenHandlerType() {
        AlloyForgeScreenHandler.ALLOY_FORGE_SCREEN_HANDLER_TYPE = class_2378.method_10230(
            class_7923.field_41187,
            id("alloy_forge"),
            INSTANCE.createScreenHandlerType(
                (syncId, inventory, location) -> new AlloyForgeScreenHandler(syncId, inventory, location.get(inventory.field_7546, ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY)),
                CodecUtils.toPacketCodec(BlockEntityLocation.ENDEC))
        );
    }

    public static void registerBlockEntities() {
        ForgeControllerBlockEntity.FORGE_CONTROLLER_BLOCK_ENTITY = class_2378.method_10230(class_7923.field_41181, id("forge_controller"), INSTANCE.createBlockEntityType(ForgeControllerBlockEntity::new));
    }

    public static void registerRecipeTypes() {
        class_2378.method_10230(class_7923.field_41188, AlloyForgeRecipe.Type.ID, AlloyForgeRecipe.Type.INSTANCE);
    }

    public static void registerRecipeSerializers() {
        class_2378.method_10230(class_7923.field_41189, AlloyForgeRecipe.Type.ID, AlloyForgeRecipeSerializer.INSTANCE);
    }

    public static void registerSlotDisplays() {
        class_2378.method_10230(class_7923.field_54873, id("counted_ingredient"), CountedIngredientDisplay.SERIALIZER);
    }

    public static void registerItemGroup() {
        AlloyForgeryItemGroup.GROUP.initialize();
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }

    public static String translationKey(String suffix) {
        return MOD_ID + "." + suffix;
    }

    public static class_5250 translation(String prefix, String suffix, Object... args) {
        return class_2561.method_43469(prefix + "." + MOD_ID + "." + suffix, args);
    }

    public static class_5250 tooltipTranslation(String suffix, Object... args) {
        return translation("tooltip", suffix, args);
    }
}
