package io.wispforest.alloyforgery.client;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import io.wispforest.alloyforgery.AlloyForgeScreenHandler;
import io.wispforest.alloyforgery.AlloyForgery;
import io.wispforest.alloyforgery.networking.AlloyForgeNetworking;
import io.wispforest.alloyforgery.networking.DisableSlotToggle;
import io.wispforest.alloyforgery.utils.ForgeInputSlot;
import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.*;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_1059;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4730;
import net.minecraft.class_5684;

import static io.wispforest.owo.ui.container.Containers.*;
import static io.wispforest.owo.ui.component.Components.*;
import static io.wispforest.alloyforgery.client.ComponentUtils.*;

public class AlloyForgeScreen extends BaseOwoHandledScreen<FlowLayout, AlloyForgeScreenHandler> {

    private static final class_4730 LAVA_SPRITE = new class_4730(class_1059.field_5275, class_2960.method_60654("block/lava_still"));

    private static final class_2561 ENABLED_SLOT_TEXT = class_2561.method_43471("tooltip.alloy-forgery.enabled_slot");
    private static final class_2561 DISABLED_SLOT_TEXT = class_2561.method_43471("tooltip.alloy-forgery.disabled_slot");

    private TextureComponent fuelGauge;
    private TextureComponent progressGauge;
    private TextureComponent invalidCross;
    private FlowLayout lavaBar;

    private boolean allowSlotToggling = false;

    public AlloyForgeScreen(AlloyForgeScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);

        this.field_2792 = 176;
        this.field_2779 = 189;

        this.field_25268 = 69420;
        this.field_25270 = this.field_2779 - 93;
    }

    @Override
    protected @NotNull OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create(this, Containers::verticalFlow);
    }

    @Override
    protected void build(FlowLayout rootComponent) {
        rootComponent.child(
            verticalFlow(Sizing.fixed(176), Sizing.fixed(189))
                .child(
                    // fuel Gauge
                    fuelGauge = texture(themedTextureID("fuel_meter.png"), 22, 0, 22, 48, 44, 48)
                        .visibleArea(PositionedRectangle.of(0, 0, 22, 0))
                        .configure(textureComponent -> {
                            textureComponent.positioning(Positioning.absolute(5, 22))
                                .id("fuel-gauge");
                        })
                )
                .child(
                    // progress Gauge
                    progressGauge = texture(textureID("forging_status.png"), 24, 3, 15, 19, 40, 22)
                        .visibleArea(PositionedRectangle.of(0, 0, 15, 0))
                        .configure(textureComponent -> {
                            textureComponent.positioning(Positioning.absolute(147, 24))
                                .id("progress-gauge");
                        })
                )
                .child(
                    // Invalid Cross
                    invalidCross = texture(textureID("cross.png"), 0, 0, 14, 14, 14, 14)
                        .visibleArea(PositionedRectangle.of(0, 0, 14, 0))
                        .configure(textureComponent -> {
                            textureComponent.positioning(Positioning.absolute(147, 25))
                                .id("invalid-cross");
                        })
                )
                .child(
                    lavaBar = horizontalFlow(Sizing.fixed(0), Sizing.fixed(10))
                        .child(sprite(LAVA_SPRITE))
                        .child(sprite(LAVA_SPRITE))
                        .child(sprite(LAVA_SPRITE))
                        .child(sprite(LAVA_SPRITE))
                        .configure(layout -> {
                            layout.positioning(Positioning.absolute(63, 4))
                                .id("lava-bar");
                        })
                )
                .child(
                    label(class_2561.method_43471("title.alloy-forgery.forge_controller"))
                        .color(getThemedValue(Color.ofRgb(0x3f3f3f), Color.WHITE))
                        .positioning(Positioning.relative(50, 12))
                )
                .child(
                    horizontalFlow(Sizing.fixed(26), Sizing.content())
                        .child(
                            button(class_2561.method_43473(), btn -> {
                                this.allowSlotToggling = !allowSlotToggling;

                                btn.tooltip(class_2561.method_43471("tooltip.alloy-forgery.slot_toggle_" + (this.allowSlotToggling ? "enable" : "disable")));
                            }).renderer((context, button, delta) -> {
                                    BUTTON_RENDERER.draw(context, button, delta);

                                    context.push()
                                        .translate(button.method_46426(), button.method_46427());

                                    context.method_25290(class_10799.field_56883, textureID("slot_locks.png"),4, 3, this.allowSlotToggling ? 10 : 0, 0, 10, 12, 20, 12);

                                    context.pop();
                                })
                                .tooltip(class_2561.method_43471("tooltip.alloy-forgery.slot_toggle_disable"))
                                .sizing(Sizing.fixed(18), Sizing.fixed(18))
                        ).horizontalAlignment(HorizontalAlignment.CENTER)
                        .positioning(Positioning.absolute(140, 75))
                )
                .child(
                    makeInputSlots(this.method_17577().getInputSlots(), 1, AlloyForgery.CONFIG::darkModeTheme, slot -> new SlotComponent(slot.field_7874){
                        // TODO: REMOVE AS THIS IS Used to resolve clipping item text and other effects due to how rendering is more buffered and uses the wrong scissor
                        @Override
                        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
                            this.didDraw = true;
                        }
                    }, this.field_2797::isSlotDisabled)
                        .positioning(Positioning.absolute(42, 41))
                )
                .surface((context, component) -> {
                    var backgroundTexture = themedTextureID("forge_controller_base.png");

                    context.push().translate(component.x(), component.y());

                    context.method_25290(class_10799.field_56883, backgroundTexture, 0, 0, 0, 0, 176, 189, 176, 189);

                    context.method_25290(class_10799.field_56883, themedTextureID("fuel_meter.png"), 5, 22, 0, 0, 22, 48, 44, 48);

                    context.method_25290(class_10799.field_56883, textureID("forging_status.png"), 143, 21, 0, 0, 20, 22, 40, 22);

                    context.pop();
                })
                .id("main-layout")
        );

        rootComponent
            .verticalAlignment(VerticalAlignment.CENTER)
            .horizontalAlignment(HorizontalAlignment.CENTER)
            .surface(Surface.VANILLA_TRANSLUCENT);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.fuelGauge.visibleArea(PositionedRectangle.of(0, this.fuelGauge.height() - this.field_2797.getFuelProgress(), this.fuelGauge.fullSize()));
        this.progressGauge.visibleArea(PositionedRectangle.of(0, 0, this.progressGauge.width(), this.field_2797.getSmeltProgress()));
        this.lavaBar.horizontalSizing(Sizing.fixed(this.field_2797.getLavaProgress()));

        int requiredTier = this.field_2797.getRequiredTierData();

        if (requiredTier <= -1) {
            this.invalidCross
                .visibleArea(PositionedRectangle.of(0, 0, 0, 0))
                .tooltip(List.<class_5684>of());
        } else {
            this.invalidCross
                .resetVisibleArea()
                .tooltip(class_2561.method_43469("tooltip.alloy-forgery.invalid_tier", requiredTier));
        }
    }

    @Override
    protected void method_2380(class_332 context, int x, int y) {
        super.method_2380(context, x, y);

        if (this.allowSlotToggling
            && this.field_2787 instanceof ForgeInputSlot
            && this.field_2797.method_34255().method_7960()
            && !this.field_2787.method_7681()
            && !this.field_2797.player().method_7325()) {

            if (this.field_2797.isSlotDisabled(this.field_2787)) {
                context.method_51438(this.field_22793, DISABLED_SLOT_TEXT, x, y);
            } else {
                context.method_51438(this.field_22793, ENABLED_SLOT_TEXT, x, y);
            }
        }
    }

    @Override
    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        var player = this.field_2797.player();

        if (allowSlotToggling && slot instanceof ForgeInputSlot && !slot.method_7681() && !player.method_7325()) {
            if (actionType == net.minecraft.class_1713.field_7790) {
                if (this.field_2797.isSlotDisabled(slot)) {
                    this.setSlotEnabled(slot, true);
                } else /*if (this.handler.getCursorStack().isEmpty())*/ {
                    this.setSlotEnabled(slot, false);
                }
            } else if(actionType == class_1713.field_7791) {
                var itemStack = player.method_31548().method_5438(button);
                if (this.field_2797.isSlotDisabled(slot) && !itemStack.method_7960()) {
                    this.setSlotEnabled(slot, true);
                }
            }
        }

        super.method_2383(slot, slotId, button, actionType);
    }

    private void setSlotEnabled(class_1735 slot, boolean enabled) {
        AlloyForgeNetworking.CHANNEL.clientHandle().send(new DisableSlotToggle(this.field_2797.forge, slot.method_34266(), !enabled));

        super.method_54590(slot.field_7874, this.field_2797.field_7763, enabled);
        float f = enabled ? 1.0F : 0.75F;
        this.field_2797.player().method_5783(class_3417.field_15015.comp_349(), 0.4F, f);
    }

    public int rootX() {
        return this.field_2776;
    }

    public int rootY() {
        return this.field_2800;
    }
}
