package io.wispforest.alloyforgery.client;

import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public record BlockEntityLocation(class_2338 blockPos, class_5321<class_1937> worldKey) {
    public static final StructEndec<BlockEntityLocation> ENDEC = StructEndecBuilder.of(
        MinecraftEndecs.BLOCK_POS.fieldOf("blockPos", BlockEntityLocation::blockPos),
        MinecraftEndecs.IDENTIFIER.xmap(id -> class_5321.method_29179(class_7924.field_41223, id), class_5321::method_29177).fieldOf("dimensionType", BlockEntityLocation::worldKey),
        BlockEntityLocation::new
    );

    public static BlockEntityLocation of(class_2586 blockEntity) {
        var world = blockEntity.method_10997();

        if (world == null) {
            throw new IllegalStateException("Unable to create the needed BlockEntityLocation fro the given BlockEntity due to it missing its World!");
        }

        return new BlockEntityLocation(blockEntity.method_11016(), world.method_27983());
    }

    public <T extends class_2586> T get(class_1657 player, class_2591<T> blockEntityType) {
        return get(player.method_73183(), blockEntityType);
    }

    public <T extends class_2586> T get(class_1937 world, class_2591<T> blockEntityType) {
        if (!world.method_27983().equals(worldKey())) {
            var server = world.method_8503();

            if (server == null) {
                throw new IllegalStateException("Unable to get the given block entity due to a inability to get the needed server instance!");
            }

            world = server.method_3847(this.worldKey());
        }

        if (world == null) {
            throw new IllegalStateException("Unable to get the given block entity due to a inability to get the needed origin world! [World: " + this.worldKey().method_29177() + "]");
        }

        return world.method_35230(this.blockPos(), blockEntityType)
            .orElseThrow(() -> new IllegalStateException("Unable to get the given block entity due not finding any block entity at the given location! [World: " + this.worldKey().method_29177() + ", Pos: " + this.blockPos() + "]"));
    }
}
